/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.bouncycastle.cms;

import sqsaml.org.bouncycastle.asn1.ASN1OctetString;
import sqsaml.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import sqsaml.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import sqsaml.org.bouncycastle.asn1.cms.RecipientIdentifier;
import sqsaml.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import sqsaml.org.bouncycastle.cms.AuthAttributesProvider;
import sqsaml.org.bouncycastle.cms.CMSException;
import sqsaml.org.bouncycastle.cms.CMSSecureReadable;
import sqsaml.org.bouncycastle.cms.KeyTransRecipient;
import sqsaml.org.bouncycastle.cms.KeyTransRecipientId;
import sqsaml.org.bouncycastle.cms.Recipient;
import sqsaml.org.bouncycastle.cms.RecipientInformation;
import sqsaml.org.bouncycastle.cms.RecipientOperator;

public class KeyTransRecipientInformation
extends RecipientInformation {
    private KeyTransRecipientInfo info;

    KeyTransRecipientInformation(KeyTransRecipientInfo keyTransRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(keyTransRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = keyTransRecipientInfo;
        RecipientIdentifier recipientIdentifier = keyTransRecipientInfo.getRecipientIdentifier();
        if (recipientIdentifier.isTagged()) {
            ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(aSN1OctetString.getOctets());
        } else {
            IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(issuerAndSerialNumber.getName(), issuerAndSerialNumber.getSerialNumber().getValue());
        }
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException {
        return ((KeyTransRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

