/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.xml.security.utils.resolver;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import sqsaml.org.apache.xml.security.signature.XMLSignatureInput;
import sqsaml.org.apache.xml.security.utils.ClassLoaderUtils;
import sqsaml.org.apache.xml.security.utils.JavaUtils;
import sqsaml.org.apache.xml.security.utils.resolver.ResourceResolverContext;
import sqsaml.org.apache.xml.security.utils.resolver.ResourceResolverException;
import sqsaml.org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import sqsaml.org.apache.xml.security.utils.resolver.implementations.ResolverFragment;
import sqsaml.org.apache.xml.security.utils.resolver.implementations.ResolverXPointer;

public class ResourceResolver {
    private static final System.Logger LOG = System.getLogger(ResourceResolver.class.getName());
    private static final List<ResourceResolverSpi> resolverList = new CopyOnWriteArrayList<ResourceResolverSpi>();
    private static final AtomicBoolean defaultResolversAdded = new AtomicBoolean();

    public static void register(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        JavaUtils.checkRegisterPermission();
        Class<?> resourceResolverClass = ClassLoaderUtils.loadClass(className, ResourceResolver.class);
        ResourceResolver.register((ResourceResolverSpi)JavaUtils.newInstanceWithEmptyConstructor(resourceResolverClass), false);
    }

    public static void registerAtStart(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        JavaUtils.checkRegisterPermission();
        Class<?> resourceResolverClass = ClassLoaderUtils.loadClass(className, ResourceResolver.class);
        ResourceResolver.register((ResourceResolverSpi)JavaUtils.newInstanceWithEmptyConstructor(resourceResolverClass), true);
    }

    public static void register(ResourceResolverSpi resourceResolverSpi, boolean start) {
        JavaUtils.checkRegisterPermission();
        if (start) {
            resolverList.add(0, resourceResolverSpi);
        } else {
            resolverList.add(resourceResolverSpi);
        }
        LOG.log(System.Logger.Level.DEBUG, "Registered resolver: {0}", resourceResolverSpi.toString());
    }

    public static void registerClassNames(List<String> classNames) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        JavaUtils.checkRegisterPermission();
        ArrayList<ResourceResolverSpi> resourceResolversToAdd = new ArrayList<ResourceResolverSpi>(classNames.size());
        for (String className : classNames) {
            ResourceResolverSpi resourceResolverSpi = (ResourceResolverSpi)JavaUtils.newInstanceWithEmptyConstructor(ClassLoaderUtils.loadClass(className, ResourceResolver.class));
            resourceResolversToAdd.add(resourceResolverSpi);
        }
        resolverList.addAll(resourceResolversToAdd);
    }

    public static void registerDefaultResolvers() {
        if (defaultResolversAdded.compareAndSet(false, true)) {
            ArrayList<ResourceResolverSpi> resourceResolversToAdd = new ArrayList<ResourceResolverSpi>();
            resourceResolversToAdd.add(new ResolverFragment());
            resourceResolversToAdd.add(new ResolverXPointer());
            resolverList.addAll(resourceResolversToAdd);
        }
    }

    public static XMLSignatureInput resolve(ResourceResolverContext context) throws ResourceResolverException {
        for (ResourceResolverSpi resolver : resolverList) {
            LOG.log(System.Logger.Level.DEBUG, "check resolvability by class {0}", resolver.getClass().getName());
            if (!resolver.engineCanResolveURI(context)) continue;
            return resolver.engineResolveURI(context);
        }
        Object[] exArgs = new Object[]{context.uriToResolve != null ? context.uriToResolve : "null", context.baseUri};
        throw new ResourceResolverException("utils.resolver.noClass", exArgs, context.uriToResolve, context.baseUri);
    }

    public static XMLSignatureInput resolve(List<ResourceResolverSpi> individualResolvers, ResourceResolverContext context) throws ResourceResolverException {
        LOG.log(System.Logger.Level.DEBUG, "I was asked to create a ResourceResolver and got {0}", individualResolvers == null ? 0 : individualResolvers.size());
        if (individualResolvers != null) {
            for (ResourceResolverSpi resolver : individualResolvers) {
                String currentClass = resolver.getClass().getName();
                LOG.log(System.Logger.Level.DEBUG, "check resolvability by class {0}", currentClass);
                if (!resolver.engineCanResolveURI(context)) continue;
                return resolver.engineResolveURI(context);
            }
        }
        return ResourceResolver.resolve(context);
    }
}

