/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.xml.security.transforms.implementations;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.w3c.dom.Element;
import sqsaml.org.apache.xml.security.c14n.CanonicalizationException;
import sqsaml.org.apache.xml.security.c14n.implementations.Canonicalizer20010315;
import sqsaml.org.apache.xml.security.c14n.implementations.Canonicalizer20010315OmitComments;
import sqsaml.org.apache.xml.security.signature.XMLSignatureByteInput;
import sqsaml.org.apache.xml.security.signature.XMLSignatureInput;
import sqsaml.org.apache.xml.security.transforms.TransformSpi;

public class TransformC14N
extends TransformSpi {
    @Override
    protected String engineGetURI() {
        return "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    }

    @Override
    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input, OutputStream os, Element transformElement, String baseURI, boolean secureValidation) throws CanonicalizationException {
        Canonicalizer20010315 c14n = this.getCanonicalizer();
        if (os == null && (input.hasUnprocessedInput() || input.isElement() || input.isNodeSet())) {
            XMLSignatureByteInput xMLSignatureByteInput;
            ByteArrayOutputStream writer = new ByteArrayOutputStream();
            try {
                c14n.engineCanonicalize(input, (OutputStream)writer, secureValidation);
                writer.flush();
                XMLSignatureByteInput output = new XMLSignatureByteInput(writer.toByteArray());
                output.setSecureValidation(secureValidation);
                xMLSignatureByteInput = output;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new CanonicalizationException("empty", new Object[]{ex.getMessage()});
                }
            }
            writer.close();
            return xMLSignatureByteInput;
        }
        c14n.engineCanonicalize(input, os, secureValidation);
        XMLSignatureByteInput output = new XMLSignatureByteInput(null);
        output.setSecureValidation(secureValidation);
        output.setOutputStream(os);
        return output;
    }

    protected Canonicalizer20010315 getCanonicalizer() {
        return new Canonicalizer20010315OmitComments();
    }
}

