/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.xml.security.stax.impl.util;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;

public class DigestOutputStream
extends OutputStream {
    private static final System.Logger LOG = System.getLogger(DigestOutputStream.class.getName());
    protected static final transient boolean isDebugEnabled = LOG.isLoggable(System.Logger.Level.DEBUG);
    private final MessageDigest messageDigest;
    private StringBuilder stringBuilder;

    public DigestOutputStream(MessageDigest messageDigest) {
        this.messageDigest = messageDigest;
        if (isDebugEnabled) {
            this.stringBuilder = new StringBuilder();
        }
    }

    @Override
    public void write(byte[] arg0) {
        this.write(arg0, 0, arg0.length);
    }

    @Override
    public void write(int arg0) {
        byte asByte = (byte)arg0;
        this.messageDigest.update(asByte);
        if (isDebugEnabled) {
            this.stringBuilder.append((char)asByte);
        }
    }

    @Override
    public void write(byte[] arg0, int arg1, int arg2) {
        this.messageDigest.update(arg0, arg1, arg2);
        if (isDebugEnabled) {
            this.stringBuilder.append(new String(arg0, arg1, arg2, StandardCharsets.UTF_8));
        }
    }

    public byte[] getDigestValue() {
        if (isDebugEnabled) {
            LOG.log(System.Logger.Level.DEBUG, "Pre Digest: ");
            LOG.log(System.Logger.Level.DEBUG, this.stringBuilder.toString());
            LOG.log(System.Logger.Level.DEBUG, "End pre Digest ");
            this.stringBuilder = new StringBuilder();
        }
        return this.messageDigest.digest();
    }
}

