/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.xml.security.stax.impl.securityToken;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import sqsaml.org.apache.xml.security.binding.xmldsig.RSAKeyValueType;
import sqsaml.org.apache.xml.security.exceptions.XMLSecurityException;
import sqsaml.org.apache.xml.security.stax.ext.InboundSecurityContext;
import sqsaml.org.apache.xml.security.stax.impl.securityToken.AbstractInboundSecurityToken;
import sqsaml.org.apache.xml.security.stax.impl.util.IDGenerator;
import sqsaml.org.apache.xml.security.stax.securityToken.SecurityTokenConstants;

public class RsaKeyValueSecurityToken
extends AbstractInboundSecurityToken {
    private RSAKeyValueType rsaKeyValueType;

    public RsaKeyValueSecurityToken(RSAKeyValueType rsaKeyValueType, InboundSecurityContext inboundSecurityContext) {
        super(inboundSecurityContext, IDGenerator.generateID(null), SecurityTokenConstants.KeyIdentifier_KeyValue, true);
        this.rsaKeyValueType = rsaKeyValueType;
    }

    private PublicKey buildPublicKey(RSAKeyValueType rsaKeyValueType) throws InvalidKeySpecException, NoSuchAlgorithmException {
        RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(new BigInteger(1, rsaKeyValueType.getModulus()), new BigInteger(1, rsaKeyValueType.getExponent()));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(rsaPublicKeySpec);
    }

    @Override
    public PublicKey getPublicKey() throws XMLSecurityException {
        if (super.getPublicKey() == null) {
            try {
                this.setPublicKey(this.buildPublicKey(this.rsaKeyValueType));
            }
            catch (InvalidKeySpecException e) {
                throw new XMLSecurityException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new XMLSecurityException(e);
            }
        }
        return super.getPublicKey();
    }

    @Override
    public boolean isAsymmetric() {
        return true;
    }

    @Override
    public SecurityTokenConstants.TokenType getTokenType() {
        return SecurityTokenConstants.KeyValueToken;
    }
}

