/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.velocity.util.introspection;

import java.lang.reflect.Method;
import sqsaml.org.apache.velocity.util.introspection.AbstractChainableUberspector;
import sqsaml.org.apache.velocity.util.introspection.Info;
import sqsaml.org.apache.velocity.util.introspection.Introspector;
import sqsaml.org.apache.velocity.util.introspection.Uberspect;
import sqsaml.org.apache.velocity.util.introspection.VelMethod;
import sqsaml.org.apache.velocity.util.introspection.VelPropertyGet;
import sqsaml.org.apache.velocity.util.introspection.VelPropertySet;

public class DeprecatedCheckUberspector
extends AbstractChainableUberspector
implements Uberspect {
    @Override
    public void init() {
        super.init();
        this.introspector = new Introspector(this.log);
    }

    @Override
    public VelMethod getMethod(Object obj, String methodName, Object[] args, Info i) {
        Method m;
        VelMethod method = super.getMethod(obj, methodName, args, i);
        if (method != null && (m = this.introspector.getMethod(obj.getClass(), method.getMethodName(), args)) != null && (m.isAnnotationPresent(Deprecated.class) || m.getDeclaringClass().isAnnotationPresent(Deprecated.class) || obj.getClass().isAnnotationPresent(Deprecated.class))) {
            this.logWarning("method", obj, method.getMethodName(), i);
        }
        return method;
    }

    @Override
    public VelPropertyGet getPropertyGet(Object obj, String identifier, Info i) {
        Method m;
        VelPropertyGet method = super.getPropertyGet(obj, identifier, i);
        if (method != null && (m = this.introspector.getMethod(obj.getClass(), method.getMethodName(), new Object[0])) != null && (m.isAnnotationPresent(Deprecated.class) || m.getDeclaringClass().isAnnotationPresent(Deprecated.class) || obj.getClass().isAnnotationPresent(Deprecated.class))) {
            this.logWarning("getter", obj, method.getMethodName(), i);
        }
        return method;
    }

    @Override
    public VelPropertySet getPropertySet(Object obj, String identifier, Object arg, Info i) {
        Method m;
        VelPropertySet method = super.getPropertySet(obj, identifier, arg, i);
        if (method != null && (m = this.introspector.getMethod(obj.getClass(), method.getMethodName(), new Object[]{arg})) != null && (m.isAnnotationPresent(Deprecated.class) || m.getDeclaringClass().isAnnotationPresent(Deprecated.class) || obj.getClass().isAnnotationPresent(Deprecated.class))) {
            this.logWarning("setter", obj, method.getMethodName(), i);
        }
        return method;
    }

    private void logWarning(String deprecationType, Object object, String methodName, Info info) {
        this.log.warn("Deprecated usage of {} [{}] in {}@{},{}", new Object[]{deprecationType, object.getClass().getCanonicalName() + "." + methodName, info.getTemplateName(), info.getLine(), info.getColumn()});
    }
}

