/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.jcp.xml.dsig.internal.dom;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sqsaml.javax.xml.crypto.AlgorithmMethod;
import sqsaml.javax.xml.crypto.KeySelector;
import sqsaml.javax.xml.crypto.KeySelectorException;
import sqsaml.javax.xml.crypto.KeySelectorResult;
import sqsaml.javax.xml.crypto.MarshalException;
import sqsaml.javax.xml.crypto.XMLCryptoContext;
import sqsaml.javax.xml.crypto.XMLStructure;
import sqsaml.javax.xml.crypto.dom.DOMCryptoContext;
import sqsaml.javax.xml.crypto.dsig.Manifest;
import sqsaml.javax.xml.crypto.dsig.Reference;
import sqsaml.javax.xml.crypto.dsig.SignatureMethod;
import sqsaml.javax.xml.crypto.dsig.SignedInfo;
import sqsaml.javax.xml.crypto.dsig.Transform;
import sqsaml.javax.xml.crypto.dsig.XMLObject;
import sqsaml.javax.xml.crypto.dsig.XMLSignContext;
import sqsaml.javax.xml.crypto.dsig.XMLSignature;
import sqsaml.javax.xml.crypto.dsig.XMLSignatureException;
import sqsaml.javax.xml.crypto.dsig.XMLValidateContext;
import sqsaml.javax.xml.crypto.dsig.dom.DOMSignContext;
import sqsaml.javax.xml.crypto.dsig.dom.DOMValidateContext;
import sqsaml.javax.xml.crypto.dsig.keyinfo.KeyInfo;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.AbstractDOMSignatureMethod;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.DOMKeyInfo;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.DOMManifest;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.DOMReference;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.DOMSignedInfo;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.DOMStructure;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.DOMUtils;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.DOMXMLObject;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.Utils;
import sqsaml.org.apache.xml.security.Init;
import sqsaml.org.apache.xml.security.utils.XMLUtils;

public final class DOMXMLSignature
extends DOMStructure
implements XMLSignature {
    private static final System.Logger LOG = System.getLogger(DOMXMLSignature.class.getName());
    private final String id;
    private final XMLSignature.SignatureValue sv;
    private KeyInfo ki;
    private List<XMLObject> objects;
    private final SignedInfo si;
    private Document ownerDoc = null;
    private Element localSigElem = null;
    private Element sigElem = null;
    private boolean validationStatus;
    private boolean validated = false;
    private KeySelectorResult ksr;
    private Map<String, XMLStructure> signatureIdMap;

    public DOMXMLSignature(SignedInfo si, KeyInfo ki, List<? extends XMLObject> objs, String id, String signatureValueId) {
        if (si == null) {
            throw new NullPointerException("signedInfo cannot be null");
        }
        this.si = si;
        this.id = id;
        this.sv = new DOMSignatureValue(signatureValueId);
        if (objs == null) {
            this.objects = Collections.emptyList();
        } else {
            this.objects = Collections.unmodifiableList(new ArrayList<XMLObject>(objs));
            int size = this.objects.size();
            for (int i = 0; i < size; ++i) {
                if (this.objects.get(i) instanceof XMLObject) continue;
                throw new ClassCastException("objs[" + i + "] is not an XMLObject");
            }
        }
        this.ki = ki;
    }

    public DOMXMLSignature(Element sigElem, XMLCryptoContext context, Provider provider) throws MarshalException {
        this.localSigElem = sigElem;
        this.ownerDoc = this.localSigElem.getOwnerDocument();
        this.id = DOMUtils.getAttributeValue(this.localSigElem, "Id");
        Element siElem = DOMUtils.getFirstChildElement(this.localSigElem, "SignedInfo", "http://www.w3.org/2000/09/xmldsig#");
        this.si = new DOMSignedInfo(siElem, context, provider);
        Element sigValElem = DOMUtils.getNextSiblingElement(siElem, "SignatureValue", "http://www.w3.org/2000/09/xmldsig#");
        this.sv = new DOMSignatureValue(sigValElem);
        Element nextSibling = DOMUtils.getNextSiblingElement(sigValElem);
        if (nextSibling != null && "KeyInfo".equals(nextSibling.getLocalName()) && "http://www.w3.org/2000/09/xmldsig#".equals(nextSibling.getNamespaceURI())) {
            this.ki = new DOMKeyInfo(nextSibling, context, provider);
            nextSibling = DOMUtils.getNextSiblingElement(nextSibling);
        }
        if (nextSibling == null) {
            this.objects = Collections.emptyList();
        } else {
            ArrayList<DOMXMLObject> tempObjects = new ArrayList<DOMXMLObject>();
            while (nextSibling != null) {
                String name = nextSibling.getLocalName();
                String namespace = nextSibling.getNamespaceURI();
                if (!"Object".equals(name) || !"http://www.w3.org/2000/09/xmldsig#".equals(namespace)) {
                    throw new MarshalException("Invalid element name: " + namespace + ":" + name + ", expected KeyInfo or Object");
                }
                tempObjects.add(new DOMXMLObject(nextSibling, context, provider));
                nextSibling = DOMUtils.getNextSiblingElement(nextSibling);
            }
            this.objects = Collections.unmodifiableList(tempObjects);
        }
    }

    public String getId() {
        return this.id;
    }

    public KeyInfo getKeyInfo() {
        return this.ki;
    }

    public SignedInfo getSignedInfo() {
        return this.si;
    }

    public List<XMLObject> getObjects() {
        return this.objects;
    }

    public XMLSignature.SignatureValue getSignatureValue() {
        return this.sv;
    }

    public KeySelectorResult getKeySelectorResult() {
        return this.ksr;
    }

    @Override
    public void marshal(Node parent, String dsPrefix, DOMCryptoContext context) throws MarshalException {
        this.marshal(parent, null, dsPrefix, context);
    }

    public void marshal(Node parent, Node nextSibling, String dsPrefix, DOMCryptoContext context) throws MarshalException {
        this.ownerDoc = DOMUtils.getOwnerDocument(parent);
        this.sigElem = DOMUtils.createElement(this.ownerDoc, "Signature", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        if (dsPrefix == null || dsPrefix.length() == 0) {
            this.sigElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
        } else {
            this.sigElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + dsPrefix, "http://www.w3.org/2000/09/xmldsig#");
        }
        ((DOMSignedInfo)this.si).marshal(this.sigElem, dsPrefix, context);
        ((DOMSignatureValue)this.sv).marshal(this.sigElem, dsPrefix, context);
        if (this.ki != null) {
            ((DOMKeyInfo)this.ki).marshal(this.sigElem, null, dsPrefix, context);
        }
        for (XMLObject object : this.objects) {
            ((DOMXMLObject)object).marshal(this.sigElem, dsPrefix, context);
        }
        DOMUtils.setAttributeID(this.sigElem, "Id", this.id);
        parent.insertBefore(this.sigElem, nextSibling);
    }

    public boolean validate(XMLValidateContext vc) throws XMLSignatureException {
        boolean refValid;
        if (vc == null) {
            throw new NullPointerException("validateContext is null");
        }
        if (!(vc instanceof DOMValidateContext)) {
            throw new ClassCastException("validateContext must be of type DOMValidateContext");
        }
        if (this.validated) {
            return this.validationStatus;
        }
        boolean sigValidity = this.sv.validate(vc);
        if (!sigValidity) {
            this.validationStatus = false;
            this.validated = true;
            return this.validationStatus;
        }
        List refs = this.si.getReferences();
        boolean validateRefs = true;
        int size = refs.size();
        for (int i = 0; validateRefs && i < size; validateRefs &= refValid, ++i) {
            Reference ref = (Reference)refs.get(i);
            refValid = ref.validate(vc);
            LOG.log(System.Logger.Level.DEBUG, "Reference [{0}] is valid: {1}", ref.getURI(), refValid);
        }
        if (!validateRefs) {
            LOG.log(System.Logger.Level.DEBUG, "Couldn't validate the References");
            this.validationStatus = false;
            this.validated = true;
            return this.validationStatus;
        }
        boolean validateMans = true;
        if (Boolean.TRUE.equals(vc.getProperty("org.jcp.xml.dsig.validateManifests"))) {
            int size2 = this.objects.size();
            for (int i = 0; validateMans && i < size2; ++i) {
                XMLObject xo = this.objects.get(i);
                List content = xo.getContent();
                int csize = content.size();
                for (int j = 0; validateMans && j < csize; ++j) {
                    boolean refValid2;
                    XMLStructure xs = (XMLStructure)content.get(j);
                    if (!(xs instanceof Manifest)) continue;
                    LOG.log(System.Logger.Level.DEBUG, "validating manifest");
                    Manifest man = (Manifest)xs;
                    List manRefs = man.getReferences();
                    int rsize = manRefs.size();
                    for (int k = 0; validateMans && k < rsize; validateMans &= refValid2, ++k) {
                        Reference ref = (Reference)manRefs.get(k);
                        refValid2 = ref.validate(vc);
                        LOG.log(System.Logger.Level.DEBUG, "Manifest ref [{0}] is valid: {1}", ref.getURI(), refValid2);
                    }
                }
            }
        }
        this.validationStatus = validateMans;
        this.validated = true;
        return this.validationStatus;
    }

    public void sign(XMLSignContext signContext) throws MarshalException, XMLSignatureException {
        if (signContext == null) {
            throw new NullPointerException("signContext cannot be null");
        }
        DOMSignContext context = (DOMSignContext)signContext;
        this.marshal(context.getParent(), context.getNextSibling(), DOMUtils.getSignaturePrefix((XMLCryptoContext)context), (DOMCryptoContext)context);
        ArrayList<Reference> allReferences = new ArrayList<Reference>();
        this.signatureIdMap = new HashMap<String, XMLStructure>();
        this.signatureIdMap.put(this.id, this);
        this.signatureIdMap.put(this.si.getId(), (XMLStructure)this.si);
        List refs = this.si.getReferences();
        for (Reference ref : refs) {
            this.signatureIdMap.put(ref.getId(), (XMLStructure)ref);
        }
        for (XMLObject obj : this.objects) {
            this.signatureIdMap.put(obj.getId(), (XMLStructure)obj);
            List content = obj.getContent();
            for (XMLStructure xs : content) {
                if (!(xs instanceof Manifest)) continue;
                Manifest man = (Manifest)xs;
                this.signatureIdMap.put(man.getId(), (XMLStructure)man);
                List manRefs = man.getReferences();
                for (Reference ref : manRefs) {
                    allReferences.add(ref);
                    this.signatureIdMap.put(ref.getId(), (XMLStructure)ref);
                }
            }
        }
        allReferences.addAll(refs);
        for (Reference ref : allReferences) {
            this.digestReference((DOMReference)ref, signContext);
        }
        for (Reference ref : allReferences) {
            if (((DOMReference)ref).isDigested()) continue;
            ((DOMReference)ref).digest(signContext);
        }
        Key signingKey = null;
        try {
            KeySelectorResult keySelectorResult = signContext.getKeySelector().select(this.ki, KeySelector.Purpose.SIGN, (AlgorithmMethod)this.si.getSignatureMethod(), (XMLCryptoContext)signContext);
            signingKey = keySelectorResult.getKey();
            if (signingKey == null) {
                throw new XMLSignatureException("the keySelector did not find a signing key");
            }
            this.ksr = keySelectorResult;
        }
        catch (KeySelectorException kse) {
            throw new XMLSignatureException("cannot find signing key", (Throwable)kse);
        }
        try {
            byte[] val = ((AbstractDOMSignatureMethod)this.si.getSignatureMethod()).sign(signingKey, this.si, signContext);
            ((DOMSignatureValue)this.sv).setValue(val);
        }
        catch (InvalidKeyException ike) {
            throw new XMLSignatureException((Throwable)ike);
        }
        this.localSigElem = this.sigElem;
    }

    public boolean equals(Object o) {
        boolean idEqual;
        if (this == o) {
            return true;
        }
        if (!(o instanceof XMLSignature)) {
            return false;
        }
        XMLSignature osig = (XMLSignature)o;
        boolean bl = this.id == null ? osig.getId() == null : (idEqual = this.id.equals(osig.getId()));
        boolean keyInfoEqual = this.ki == null ? osig.getKeyInfo() == null : this.ki.equals(osig.getKeyInfo());
        return idEqual && keyInfoEqual && this.sv.equals(osig.getSignatureValue()) && this.si.equals(osig.getSignedInfo()) && this.objects.equals(osig.getObjects());
    }

    public int hashCode() {
        int result = 17;
        if (this.id != null) {
            result = 31 * result + this.id.hashCode();
        }
        if (this.ki != null) {
            result = 31 * result + this.ki.hashCode();
        }
        result = 31 * result + this.sv.hashCode();
        result = 31 * result + this.si.hashCode();
        result = 31 * result + this.objects.hashCode();
        return result;
    }

    private void digestReference(DOMReference ref, XMLSignContext signContext) throws XMLSignatureException {
        if (ref.isDigested()) {
            return;
        }
        String uri = ref.getURI();
        if (Utils.sameDocumentURI(uri)) {
            String parsedId = Utils.parseIdFromSameDocumentURI(uri);
            if (parsedId != null && this.signatureIdMap.containsKey(parsedId)) {
                XMLStructure xs = this.signatureIdMap.get(parsedId);
                if (xs instanceof DOMReference) {
                    this.digestReference((DOMReference)xs, signContext);
                } else if (xs instanceof Manifest) {
                    Manifest man = (Manifest)xs;
                    List<Reference> manRefs = DOMManifest.getManifestReferences(man);
                    for (Reference manRef : manRefs) {
                        this.digestReference((DOMReference)manRef, signContext);
                    }
                }
            }
            if (uri.length() == 0) {
                List<Transform> transforms = ref.getTransforms();
                for (Transform transform : transforms) {
                    String transformAlg = transform.getAlgorithm();
                    if (!transformAlg.equals("http://www.w3.org/TR/1999/REC-xpath-19991116") && !transformAlg.equals("http://www.w3.org/2002/06/xmldsig-filter2")) continue;
                    return;
                }
            }
        }
        ref.digest(signContext);
    }

    static {
        Init.init();
    }

    public class DOMSignatureValue
    extends DOMStructure
    implements XMLSignature.SignatureValue {
        private String id;
        private byte[] value;
        private String valueBase64;
        private Element sigValueElem;
        private boolean validated = false;
        private boolean validationStatus;

        DOMSignatureValue(String id) {
            this.id = id;
        }

        DOMSignatureValue(Element sigValueElem) throws MarshalException {
            String content = XMLUtils.getFullTextChildrenFromNode(sigValueElem);
            this.value = XMLUtils.decode(content);
            Attr attr = sigValueElem.getAttributeNodeNS(null, "Id");
            if (attr != null) {
                this.id = attr.getValue();
                sigValueElem.setIdAttributeNode(attr, true);
            } else {
                this.id = null;
            }
            this.sigValueElem = sigValueElem;
        }

        public String getId() {
            return this.id;
        }

        public byte[] getValue() {
            return this.value == null ? null : (byte[])this.value.clone();
        }

        public String getEncodedValue() {
            return this.valueBase64;
        }

        public boolean validate(XMLValidateContext validateContext) throws XMLSignatureException {
            if (validateContext == null) {
                throw new NullPointerException("context cannot be null");
            }
            if (this.validated) {
                return this.validationStatus;
            }
            SignatureMethod sm = DOMXMLSignature.this.si.getSignatureMethod();
            Key validationKey = null;
            KeySelectorResult ksResult = null;
            try {
                KeySelector keySelector = validateContext.getKeySelector();
                if (keySelector != null && (ksResult = keySelector.select(DOMXMLSignature.this.ki, KeySelector.Purpose.VERIFY, (AlgorithmMethod)sm, (XMLCryptoContext)validateContext)) != null) {
                    validationKey = ksResult.getKey();
                }
                if (validationKey == null) {
                    throw new XMLSignatureException("the keyselector did not find a validation key");
                }
            }
            catch (KeySelectorException kse) {
                throw new XMLSignatureException("cannot find validation key", (Throwable)kse);
            }
            try {
                this.validationStatus = ((AbstractDOMSignatureMethod)sm).verify(validationKey, DOMXMLSignature.this.si, this.value, validateContext);
            }
            catch (Exception e) {
                throw new XMLSignatureException((Throwable)e);
            }
            this.validated = true;
            DOMXMLSignature.this.ksr = ksResult;
            return this.validationStatus;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof XMLSignature.SignatureValue)) {
                return false;
            }
            XMLSignature.SignatureValue osv = (XMLSignature.SignatureValue)o;
            boolean idEqual = this.id == null ? osv.getId() == null : this.id.equals(osv.getId());
            return idEqual;
        }

        public int hashCode() {
            int result = 17;
            if (this.id != null) {
                result = 31 * result + this.id.hashCode();
            }
            return result;
        }

        @Override
        public void marshal(Node parent, String dsPrefix, DOMCryptoContext context) throws MarshalException {
            this.sigValueElem = DOMUtils.createElement(DOMXMLSignature.this.ownerDoc, "SignatureValue", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
            if (this.valueBase64 != null) {
                this.sigValueElem.appendChild(DOMXMLSignature.this.ownerDoc.createTextNode(this.valueBase64));
            }
            DOMUtils.setAttributeID(this.sigValueElem, "Id", this.id);
            parent.appendChild(this.sigValueElem);
        }

        void setValue(byte[] value) {
            this.value = value;
            this.valueBase64 = XMLUtils.encodeToString(value);
            this.sigValueElem.appendChild(DOMXMLSignature.this.ownerDoc.createTextNode(this.valueBase64));
        }
    }
}

