/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.jcp.xml.dsig.internal.dom;

import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sqsaml.javax.xml.crypto.Data;
import sqsaml.javax.xml.crypto.MarshalException;
import sqsaml.javax.xml.crypto.XMLCryptoContext;
import sqsaml.javax.xml.crypto.XMLStructure;
import sqsaml.javax.xml.crypto.dom.DOMCryptoContext;
import sqsaml.javax.xml.crypto.dsig.Transform;
import sqsaml.javax.xml.crypto.dsig.TransformException;
import sqsaml.javax.xml.crypto.dsig.TransformService;
import sqsaml.javax.xml.crypto.dsig.dom.DOMSignContext;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.DOMStructure;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.DOMUtils;

public class DOMTransform
extends DOMStructure
implements Transform {
    protected TransformService spi;

    public DOMTransform(TransformService spi) {
        this.spi = spi;
    }

    public DOMTransform(Element transElem, XMLCryptoContext context, Provider provider) throws MarshalException {
        String algorithm = DOMUtils.getAttributeValue(transElem, "Algorithm");
        if (provider == null) {
            try {
                this.spi = TransformService.getInstance((String)algorithm, (String)"DOM");
            }
            catch (NoSuchAlgorithmException e1) {
                throw new MarshalException((Throwable)e1);
            }
        }
        try {
            this.spi = TransformService.getInstance((String)algorithm, (String)"DOM", (Provider)provider);
        }
        catch (NoSuchAlgorithmException nsae) {
            try {
                this.spi = TransformService.getInstance((String)algorithm, (String)"DOM");
            }
            catch (NoSuchAlgorithmException e2) {
                throw new MarshalException((Throwable)e2);
            }
        }
        try {
            this.spi.init((XMLStructure)new sqsaml.javax.xml.crypto.dom.DOMStructure((Node)transElem), context);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new MarshalException((Throwable)iape);
        }
    }

    public final AlgorithmParameterSpec getParameterSpec() {
        return this.spi.getParameterSpec();
    }

    public final String getAlgorithm() {
        return this.spi.getAlgorithm();
    }

    @Override
    public void marshal(Node parent, String dsPrefix, DOMCryptoContext context) throws MarshalException {
        Document ownerDoc = DOMUtils.getOwnerDocument(parent);
        Element transformElem = null;
        transformElem = "Transforms".equals(parent.getLocalName()) ? DOMUtils.createElement(ownerDoc, "Transform", "http://www.w3.org/2000/09/xmldsig#", dsPrefix) : DOMUtils.createElement(ownerDoc, "CanonicalizationMethod", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        DOMUtils.setAttribute(transformElem, "Algorithm", this.getAlgorithm());
        this.spi.marshalParams((XMLStructure)new sqsaml.javax.xml.crypto.dom.DOMStructure((Node)transformElem), (XMLCryptoContext)context);
        parent.appendChild(transformElem);
    }

    public Data transform(Data data, XMLCryptoContext xc) throws TransformException {
        return this.spi.transform(data, xc);
    }

    public Data transform(Data data, XMLCryptoContext xc, OutputStream os) throws TransformException {
        return this.spi.transform(data, xc, os);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Transform)) {
            return false;
        }
        Transform otransform = (Transform)o;
        return this.getAlgorithm().equals(otransform.getAlgorithm()) && DOMUtils.paramsEqual(this.getParameterSpec(), otransform.getParameterSpec());
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getAlgorithm().hashCode();
        AlgorithmParameterSpec spec = this.getParameterSpec();
        if (spec != null) {
            result = 31 * result + spec.hashCode();
        }
        return result;
    }

    Data transform(Data data, XMLCryptoContext xc, DOMSignContext context) throws MarshalException, TransformException {
        this.marshal(context.getParent(), DOMUtils.getSignaturePrefix((XMLCryptoContext)context), (DOMCryptoContext)context);
        return this.transform(data, xc);
    }
}

