/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.jcp.xml.dsig.internal.dom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sqsaml.javax.xml.crypto.Data;
import sqsaml.javax.xml.crypto.MarshalException;
import sqsaml.javax.xml.crypto.NodeSetData;
import sqsaml.javax.xml.crypto.OctetStreamData;
import sqsaml.javax.xml.crypto.XMLCryptoContext;
import sqsaml.javax.xml.crypto.XMLStructure;
import sqsaml.javax.xml.crypto.dom.DOMCryptoContext;
import sqsaml.javax.xml.crypto.dom.DOMStructure;
import sqsaml.javax.xml.crypto.dsig.TransformException;
import sqsaml.javax.xml.crypto.dsig.TransformService;
import sqsaml.javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.ApacheData;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.ApacheNodeSetData;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.ApacheOctetStreamData;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.DOMSubTreeData;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.DOMUtils;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.Utils;
import sqsaml.org.apache.xml.security.Init;
import sqsaml.org.apache.xml.security.c14n.Canonicalizer;
import sqsaml.org.apache.xml.security.c14n.InvalidCanonicalizerException;
import sqsaml.org.apache.xml.security.signature.XMLSignatureInput;
import sqsaml.org.apache.xml.security.signature.XMLSignatureNodeInput;
import sqsaml.org.apache.xml.security.signature.XMLSignatureNodeSetInput;
import sqsaml.org.apache.xml.security.signature.XMLSignatureStreamInput;
import sqsaml.org.apache.xml.security.transforms.Transform;

public abstract class ApacheCanonicalizer
extends TransformService {
    private static final System.Logger LOG;
    protected Canonicalizer canonicalizer;
    private Transform apacheTransform;
    protected String inclusiveNamespaces;
    protected C14NMethodParameterSpec params;
    protected Document ownerDoc;
    protected Element transformElem;

    public final AlgorithmParameterSpec getParameterSpec() {
        return this.params;
    }

    public void init(XMLStructure parent, XMLCryptoContext context) throws InvalidAlgorithmParameterException {
        if (context != null && !(context instanceof DOMCryptoContext)) {
            throw new ClassCastException("context must be of type DOMCryptoContext");
        }
        if (parent == null) {
            throw new NullPointerException();
        }
        if (!(parent instanceof DOMStructure)) {
            throw new ClassCastException("parent must be of type DOMStructure");
        }
        this.transformElem = (Element)((DOMStructure)parent).getNode();
        this.ownerDoc = DOMUtils.getOwnerDocument(this.transformElem);
    }

    public void marshalParams(XMLStructure parent, XMLCryptoContext context) throws MarshalException {
        if (context != null && !(context instanceof DOMCryptoContext)) {
            throw new ClassCastException("context must be of type DOMCryptoContext");
        }
        if (parent == null) {
            throw new NullPointerException();
        }
        if (!(parent instanceof DOMStructure)) {
            throw new ClassCastException("parent must be of type DOMStructure");
        }
        this.transformElem = (Element)((DOMStructure)parent).getNode();
        this.ownerDoc = DOMUtils.getOwnerDocument(this.transformElem);
    }

    public Data canonicalize(Data data, XMLCryptoContext xc) throws TransformException {
        return this.canonicalize(data, xc, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Data canonicalize(Data data, XMLCryptoContext xc, OutputStream os) throws TransformException {
        if (this.canonicalizer == null) {
            try {
                this.canonicalizer = Canonicalizer.getInstance(this.getAlgorithm());
                LOG.log(System.Logger.Level.DEBUG, "Created canonicalizer for algorithm: {0}", this.getAlgorithm());
            }
            catch (InvalidCanonicalizerException ice) {
                throw new TransformException("Couldn't find Canonicalizer for: " + this.getAlgorithm() + ": " + ice.getMessage(), (Throwable)ice);
            }
        }
        boolean isByteArrayOutputStream = os == null;
        OutputStream writer = isByteArrayOutputStream ? new ByteArrayOutputStream() : os;
        try {
            boolean secVal = Utils.secureValidation(xc);
            Set<Node> nodeSet = null;
            if (data instanceof ApacheData) {
                XMLSignatureInput in = ((ApacheData)data).getXMLSignatureInput();
                if (in.isElement()) {
                    if (this.inclusiveNamespaces != null) {
                        this.canonicalizer.canonicalizeSubtree(in.getSubNode(), this.inclusiveNamespaces, writer);
                        return new OctetStreamData((InputStream)new ByteArrayInputStream(this.getC14nBytes(writer, isByteArrayOutputStream)));
                    }
                    this.canonicalizer.canonicalizeSubtree(in.getSubNode(), writer);
                    return new OctetStreamData((InputStream)new ByteArrayInputStream(this.getC14nBytes(writer, isByteArrayOutputStream)));
                }
                if (!in.isNodeSet()) {
                    this.canonicalizer.canonicalize(Utils.readBytesFromStream(in.getUnprocessedInput()), writer, secVal);
                    return new OctetStreamData((InputStream)new ByteArrayInputStream(this.getC14nBytes(writer, isByteArrayOutputStream)));
                }
                nodeSet = in.getNodeSet();
            } else {
                if (data instanceof DOMSubTreeData) {
                    DOMSubTreeData subTree = (DOMSubTreeData)data;
                    if (this.inclusiveNamespaces != null) {
                        this.canonicalizer.canonicalizeSubtree(subTree.getRoot(), this.inclusiveNamespaces, writer);
                        return new OctetStreamData((InputStream)new ByteArrayInputStream(this.getC14nBytes(writer, isByteArrayOutputStream)));
                    }
                    this.canonicalizer.canonicalizeSubtree(subTree.getRoot(), writer);
                    return new OctetStreamData((InputStream)new ByteArrayInputStream(this.getC14nBytes(writer, isByteArrayOutputStream)));
                }
                if (!(data instanceof NodeSetData)) {
                    this.canonicalizer.canonicalize(Utils.readBytesFromStream(((OctetStreamData)data).getOctetStream()), writer, secVal);
                    return new OctetStreamData((InputStream)new ByteArrayInputStream(this.getC14nBytes(writer, isByteArrayOutputStream)));
                }
                NodeSetData nsd = (NodeSetData)data;
                Set<Node> ns = Utils.toNodeSet(nsd.iterator());
                nodeSet = ns;
                LOG.log(System.Logger.Level.DEBUG, "Canonicalizing {0} nodes", nodeSet.size());
            }
            if (this.inclusiveNamespaces != null) {
                this.canonicalizer.canonicalizeXPathNodeSet(nodeSet, this.inclusiveNamespaces, writer);
                return new OctetStreamData((InputStream)new ByteArrayInputStream(this.getC14nBytes(writer, isByteArrayOutputStream)));
            }
            this.canonicalizer.canonicalizeXPathNodeSet(nodeSet, writer);
            return new OctetStreamData((InputStream)new ByteArrayInputStream(this.getC14nBytes(writer, isByteArrayOutputStream)));
        }
        catch (Exception e) {
            throw new TransformException((Throwable)e);
        }
    }

    private byte[] getC14nBytes(OutputStream outputStream, boolean isByteArrayOutputStream) {
        if (isByteArrayOutputStream) {
            return ((ByteArrayOutputStream)outputStream).toByteArray();
        }
        return null;
    }

    public Data transform(Data data, XMLCryptoContext xc, OutputStream os) throws TransformException {
        XMLSignatureInput in;
        if (data == null) {
            throw new NullPointerException("data must not be null");
        }
        if (os == null) {
            throw new NullPointerException("output stream must not be null");
        }
        if (this.ownerDoc == null) {
            throw new TransformException("transform must be marshalled");
        }
        if (this.apacheTransform == null) {
            try {
                this.apacheTransform = new Transform(this.ownerDoc, this.getAlgorithm(), this.transformElem.getChildNodes());
                this.apacheTransform.setElement(this.transformElem, xc.getBaseURI());
                LOG.log(System.Logger.Level.DEBUG, "Created transform for algorithm: {0}", this.getAlgorithm());
            }
            catch (Exception ex) {
                throw new TransformException("Couldn't find Transform for: " + this.getAlgorithm(), (Throwable)ex);
            }
        }
        if (data instanceof ApacheData) {
            LOG.log(System.Logger.Level.DEBUG, "ApacheData = true");
            in = ((ApacheData)data).getXMLSignatureInput();
        } else if (data instanceof NodeSetData) {
            LOG.log(System.Logger.Level.DEBUG, "isNodeSet() = true");
            if (data instanceof DOMSubTreeData) {
                DOMSubTreeData subTree = (DOMSubTreeData)data;
                in = new XMLSignatureNodeInput(subTree.getRoot());
                in.setExcludeComments(subTree.excludeComments());
            } else {
                Set<Node> nodeSet = Utils.toNodeSet(((NodeSetData)data).iterator());
                in = new XMLSignatureNodeSetInput(nodeSet);
            }
        } else {
            LOG.log(System.Logger.Level.DEBUG, "isNodeSet() = false");
            try {
                in = new XMLSignatureStreamInput(((OctetStreamData)data).getOctetStream());
            }
            catch (Exception ex) {
                throw new TransformException((Throwable)ex);
            }
        }
        boolean secVal = Utils.secureValidation(xc);
        in.setSecureValidation(secVal);
        try {
            in = this.apacheTransform.performTransform(in, os, secVal);
            if (in.hasUnprocessedInput()) {
                return new ApacheOctetStreamData(in);
            }
            return new ApacheNodeSetData(in);
        }
        catch (Exception ex) {
            throw new TransformException((Throwable)ex);
        }
    }

    public final boolean isFeatureSupported(String feature) {
        if (feature == null) {
            throw new NullPointerException();
        }
        return false;
    }

    static {
        Init.init();
        LOG = System.getLogger(ApacheCanonicalizer.class.getName());
    }
}

