/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.commons.ssl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sqsaml.org.apache.commons.ssl.SSLClient;
import sqsaml.org.apache.commons.ssl.TrustMaterial;

public class LDAPSocket
extends SSLClient {
    private static final Log logger = LogFactory.getLog(LDAPSocket.class);
    private static final LDAPSocket instance;

    private LDAPSocket() throws GeneralSecurityException, IOException {
        if (TrustMaterial.JSSE_CACERTS != null) {
            this.setTrustMaterial(TrustMaterial.JSSE_CACERTS);
        } else {
            this.setTrustMaterial(TrustMaterial.CACERTS);
        }
    }

    public static SocketFactory getDefault() {
        return LDAPSocket.getInstance();
    }

    public static LDAPSocket getInstance() {
        return instance;
    }

    static {
        LDAPSocket sf = null;
        try {
            sf = new LDAPSocket();
        }
        catch (Exception e) {
            logger.error((Object)"could not create LDAPSocket.", (Throwable)e);
        }
        finally {
            instance = sf;
        }
    }
}

