/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.commons.configuration.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import sqsaml.org.apache.commons.configuration.event.ConfigurationErrorEvent;
import sqsaml.org.apache.commons.configuration.event.ConfigurationErrorListener;
import sqsaml.org.apache.commons.configuration.event.ConfigurationEvent;
import sqsaml.org.apache.commons.configuration.event.ConfigurationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventSource {
    private Collection<ConfigurationListener> listeners;
    private Collection<ConfigurationErrorListener> errorListeners;
    private final Object lockDetailEventsCount = new Object();
    private int detailEvents;

    public EventSource() {
        this.initListeners();
    }

    public void addConfigurationListener(ConfigurationListener l) {
        EventSource.checkListener(l);
        this.listeners.add(l);
    }

    public boolean removeConfigurationListener(ConfigurationListener l) {
        return this.listeners.remove(l);
    }

    public Collection<ConfigurationListener> getConfigurationListeners() {
        return Collections.unmodifiableCollection(new ArrayList<ConfigurationListener>(this.listeners));
    }

    public void clearConfigurationListeners() {
        this.listeners.clear();
    }

    public boolean isDetailEvents() {
        return this.checkDetailEvents(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetailEvents(boolean enable) {
        Object object = this.lockDetailEventsCount;
        synchronized (object) {
            this.detailEvents = enable ? ++this.detailEvents : --this.detailEvents;
        }
    }

    public void addErrorListener(ConfigurationErrorListener l) {
        EventSource.checkListener(l);
        this.errorListeners.add(l);
    }

    public boolean removeErrorListener(ConfigurationErrorListener l) {
        return this.errorListeners.remove(l);
    }

    public void clearErrorListeners() {
        this.errorListeners.clear();
    }

    public Collection<ConfigurationErrorListener> getErrorListeners() {
        return Collections.unmodifiableCollection(new ArrayList<ConfigurationErrorListener>(this.errorListeners));
    }

    protected void fireEvent(int type, String propName, Object propValue, boolean before) {
        Iterator<ConfigurationListener> it;
        if (this.checkDetailEvents(-1) && (it = this.listeners.iterator()).hasNext()) {
            ConfigurationEvent event = this.createEvent(type, propName, propValue, before);
            while (it.hasNext()) {
                it.next().configurationChanged(event);
            }
        }
    }

    protected ConfigurationEvent createEvent(int type, String propName, Object propValue, boolean before) {
        return new ConfigurationEvent(this, type, propName, propValue, before);
    }

    protected void fireError(int type, String propName, Object propValue, Throwable ex) {
        Iterator<ConfigurationErrorListener> it = this.errorListeners.iterator();
        if (it.hasNext()) {
            ConfigurationErrorEvent event = this.createErrorEvent(type, propName, propValue, ex);
            while (it.hasNext()) {
                it.next().configurationError(event);
            }
        }
    }

    protected ConfigurationErrorEvent createErrorEvent(int type, String propName, Object propValue, Throwable ex) {
        return new ConfigurationErrorEvent((Object)this, type, propName, propValue, ex);
    }

    protected Object clone() throws CloneNotSupportedException {
        EventSource copy = (EventSource)super.clone();
        copy.initListeners();
        return copy;
    }

    private static void checkListener(Object l) {
        if (l == null) {
            throw new IllegalArgumentException("Listener must not be null!");
        }
    }

    private void initListeners() {
        this.listeners = new CopyOnWriteArrayList<ConfigurationListener>();
        this.errorListeners = new CopyOnWriteArrayList<ConfigurationErrorListener>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDetailEvents(int limit) {
        Object object = this.lockDetailEventsCount;
        synchronized (object) {
            return this.detailEvents > limit;
        }
    }
}

