/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.commons.configuration;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sqsaml.org.apache.commons.configuration.MapConfiguration;
import sqsaml.org.apache.commons.configuration.PropertiesConfiguration;
import sqsaml.org.apache.commons.configuration.XMLPropertiesConfiguration;

public class SystemConfiguration
extends MapConfiguration {
    private static Log log = LogFactory.getLog(SystemConfiguration.class);

    public SystemConfiguration() {
        super(System.getProperties());
    }

    public static void setSystemProperties(String fileName) throws Exception {
        SystemConfiguration.setSystemProperties(null, fileName);
    }

    public static void setSystemProperties(String basePath, String fileName) throws Exception {
        PropertiesConfiguration config;
        PropertiesConfiguration propertiesConfiguration = config = fileName.endsWith(".xml") ? new XMLPropertiesConfiguration() : new PropertiesConfiguration();
        if (basePath != null) {
            config.setBasePath(basePath);
        }
        config.setFileName(fileName);
        config.load();
        SystemConfiguration.setSystemProperties(config);
    }

    public static void setSystemProperties(PropertiesConfiguration systemConfig) {
        Iterator<String> iter = systemConfig.getKeys();
        while (iter.hasNext()) {
            String key = iter.next();
            String value = (String)systemConfig.getProperty(key);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting system property " + key + " to " + value));
            }
            System.setProperty(key, value);
        }
    }
}

