/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.nu.xom;

import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Locale;
import sqsaml.nu.xom.TextWriter;

class GenericWriter
extends TextWriter {
    private final boolean isJapanese;
    private final CharsetEncoder encoder;

    GenericWriter(Writer writer, String string) throws UnsupportedEncodingException {
        super(writer, string);
        string = string.toUpperCase(Locale.ENGLISH);
        this.isJapanese = string.indexOf("EUC-JP") > -1 || string.startsWith("EUC_JP") || string.equals("SHIFT_JIS") || string.equals("SJIS") || string.equals("ISO-2022-JP");
        this.encoder = Charset.forName(string).newEncoder();
    }

    @Override
    boolean needsEscaping(char c) {
        if (c <= '\u007f') {
            return false;
        }
        if (this.isJapanese) {
            if (c == '\u00a5') {
                return true;
            }
            if (c == '\u203e') {
                return true;
            }
        }
        return !this.encoder.canEncode(c);
    }
}

