/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.saml.properties;

import org.squashtest.tm.plugin.saml.properties.MetadataExpositionProperties;
import org.squashtest.tm.plugin.saml.properties.MetadataProperties;
import org.squashtest.tm.plugin.saml.properties.TrustedKeys;
import org.squashtest.tm.plugin.saml.properties.Utils;
import sqsaml.org.springframework.security.saml.metadata.ExtendedMetadata;
import sqsaml.org.springframework.security.saml.metadata.ExtendedMetadataDelegate;

public class SPProperties {
    private String signingKey;
    private String encryptionKey;
    private String tlsKey;
    private boolean requireLogoutRequestSigned = true;
    private boolean requireLogoutResponseSigned = false;
    private String signatureSecurityProfile = "metaiop";
    private String sslSecurityProfile = "pkix";
    private String sslHostnameVerification = "default";
    private boolean enableEcp = false;
    private MetadataProperties metadata = new MetadataProperties();
    private MetadataExpositionProperties metadataExposition = new MetadataExpositionProperties();

    public String getSigningKey() {
        return Utils.nullIfBlank(this.signingKey);
    }

    public void setSigningKey(String signingKey) {
        this.signingKey = signingKey;
    }

    public String getEncryptionKey() {
        return Utils.nullIfBlank(this.encryptionKey);
    }

    public void setEncryptionKey(String encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public String getTlsKey() {
        return Utils.nullIfBlank(this.tlsKey);
    }

    public void setTlsKey(String tlsKey) {
        this.tlsKey = tlsKey;
    }

    public boolean isRequireLogoutRequestSigned() {
        return this.requireLogoutRequestSigned;
    }

    public void setRequireLogoutRequestSigned(boolean requireLogoutRequestSigned) {
        this.requireLogoutRequestSigned = requireLogoutRequestSigned;
    }

    public boolean isRequireLogoutResponseSigned() {
        return this.requireLogoutResponseSigned;
    }

    public void setRequireLogoutResponseSigned(boolean requireLogoutResponseSigned) {
        this.requireLogoutResponseSigned = requireLogoutResponseSigned;
    }

    public String getSignatureSecurityProfile() {
        return Utils.defaultIfBlank(this.signatureSecurityProfile, "metaiop");
    }

    public void setSignatureSecurityProfile(String signatureSecurityProfile) {
        this.signatureSecurityProfile = signatureSecurityProfile;
    }

    public String getSslSecurityProfile() {
        return Utils.defaultIfBlank(this.sslSecurityProfile, "pkix");
    }

    public void setSslSecurityProfile(String sslSecurityProfile) {
        this.sslSecurityProfile = sslSecurityProfile;
    }

    public String getSslHostnameVerification() {
        return Utils.defaultIfBlank(this.sslHostnameVerification, "default");
    }

    public void setSslHostnameVerification(String sslHostnameVerification) {
        this.sslHostnameVerification = sslHostnameVerification;
    }

    public boolean isEnableEcp() {
        return this.enableEcp;
    }

    public void setEnableEcp(boolean enableEcp) {
        this.enableEcp = enableEcp;
    }

    public MetadataProperties getMetadata() {
        return this.metadata;
    }

    public void setMetadata(MetadataProperties metadata) {
        this.metadata = metadata;
    }

    public MetadataExpositionProperties getMetadataExposition() {
        return this.metadataExposition;
    }

    public void setMetadataExposition(MetadataExpositionProperties metadataExposition) {
        this.metadataExposition = metadataExposition;
    }

    public void configure(ExtendedMetadata meta) {
        meta.setLocal(true);
        meta.setSigningKey(this.signingKey);
        meta.setEncryptionKey(this.encryptionKey);
        meta.setTlsKey(this.tlsKey);
        meta.setRequireLogoutRequestSigned(this.requireLogoutRequestSigned);
        meta.setRequireLogoutResponseSigned(this.requireLogoutResponseSigned);
        meta.setSecurityProfile(this.signatureSecurityProfile);
        meta.setSslSecurityProfile(this.sslSecurityProfile);
        meta.setSslHostnameVerification(this.sslHostnameVerification);
        meta.setEcpEnabled(this.enableEcp);
        MetadataExpositionProperties expo = this.metadataExposition;
        meta.setSignMetadata(expo.isSigned());
        meta.setSigningAlgorithm(expo.getSigningAlgorithm());
        meta.setDigestMethodAlgorithm(expo.getDigestAlgorithm());
    }

    public void configure(ExtendedMetadataDelegate delegate) {
        delegate.setMetadataRequireSignature(this.metadata.isRequireSignature());
        delegate.setMetadataTrustCheck(this.metadata.isCheckSignature());
        delegate.setForceMetadataRevocationCheck(this.metadata.isCheckCertificateRevocation());
        delegate.setMetadataTrustedKeys(TrustedKeys.toSpringTrustedKeys(this.metadata.getTrustedKeys()));
        delegate.setRequireValidMetadata(true);
    }
}

