/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.mantis.internal.domain.project.customfields.converter.factory;

import java.util.Map;
import java.util.Optional;
import org.squashtest.tm.bugtracker.advanceddomain.InputType;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.domain.project.customfields.converter.BasicFieldConverter;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.domain.project.customfields.converter.CollectionFieldConverter;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.domain.project.customfields.converter.CustomFieldConverterType;

public class CustomFieldConverterFactory {
    private final Map<String, CustomFieldConverterType> converters;

    public CustomFieldConverterFactory() {
        this.converters = Map.ofEntries(Map.entry("string", new CustomFieldConverterType(new BasicFieldConverter(), InputType.TypeName.TEXT_FIELD.value)), Map.entry("numeric", new CustomFieldConverterType(new BasicFieldConverter(), InputType.TypeName.INTEGER.value)), Map.entry("float", new CustomFieldConverterType(new BasicFieldConverter(), InputType.TypeName.DECIMAL.value)), Map.entry("enum", new CustomFieldConverterType(new CollectionFieldConverter(), InputType.TypeName.DROPDOWN_LIST.value)), Map.entry("email", new CustomFieldConverterType(new BasicFieldConverter(), InputType.TypeName.TEXT_FIELD.value)), Map.entry("checkbox", new CustomFieldConverterType(new CollectionFieldConverter(), InputType.TypeName.CHECKBOX_LIST.value)), Map.entry("list", new CustomFieldConverterType(new CollectionFieldConverter(), InputType.TypeName.DROPDOWN_LIST.value)), Map.entry("multilist", new CustomFieldConverterType(new CollectionFieldConverter(), InputType.TypeName.MULTI_SELECT.value)), Map.entry("date", new CustomFieldConverterType(new BasicFieldConverter(), InputType.TypeName.DATE_PICKER.value)), Map.entry("9", new CustomFieldConverterType(new CollectionFieldConverter(), InputType.TypeName.RADIO_BUTTON.value)), Map.entry("textarea", new CustomFieldConverterType(new BasicFieldConverter(), InputType.TypeName.TEXT_AREA.value)));
    }

    public CustomFieldConverterType get(String type) {
        return Optional.ofNullable(this.converters.get(type)).orElseThrow(() -> new IllegalArgumentException(String.valueOf(type) + " does not exist as a custom field type!"));
    }
}

