/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.redminereq.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.querydsl.core.group.GroupBy;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.type.LongType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.domain.event.RequirementAuditEvent;
import org.squashtest.tm.domain.milestone.QMilestone;
import org.squashtest.tm.domain.project.QProject;
import org.squashtest.tm.domain.requirement.QRequirement;
import org.squashtest.tm.domain.requirement.QRequirementSyncExtender;
import org.squashtest.tm.domain.requirement.QRequirementVersion;
import org.squashtest.tm.plugin.redminereq.domain.Configuration;
import org.squashtest.tm.plugin.redminereq.domain.FieldLink;
import org.squashtest.tm.plugin.redminereq.domain.FieldMapping;
import org.squashtest.tm.plugin.redminereq.domain.FilterBinding;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.web.backend.helper.JsonHelper;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.scanner.ScannerException;

@Repository(value="squash.tm.plugin.redminereq.dao")
public class PluginDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginDao.class);
    private static final String ID_AND_KEY_BY_KEY = "select req.id, sync.remoteReqId from Requirement req inner join req.syncExtender sync where sync.remoteReqId in (:keys) and req.project.id = :projectId";
    private static final String RMV_CREAT_EVT = "delete RequirementCreation c where c.requirementVersion.id in (:vIds)";
    private static final String REDMINE3_SERVER_KIND = "redmine3.rest";
    private static final String FOR_PROJECT = " for project ";
    @PersistenceContext
    private EntityManager em;
    @Inject
    private GenericProjectManagerService projectManager;
    @Inject
    private ObjectMapper jsonifier;

    public void flush() {
        this.getSession().flush();
    }

    public void storeConfigurationForProject(Long projectId, Configuration configuration) {
        HashMap<String, String> storageConf = new HashMap<String, String>(4);
        String strSrvId = configuration.getServerId() != null ? configuration.getServerId().toString() : "0";
        storageConf.put("serverId", strSrvId);
        Collection<FilterBinding> filters = configuration.getFilterBindings();
        String strFilters = JsonHelper.serialize(filters);
        storageConf.put("filterBinding", strFilters);
        List<FieldMapping> fieldMappings = configuration.getFieldMappings();
        String strMappings = JsonHelper.serialize(fieldMappings);
        storageConf.put("attributeMappings", strMappings);
        List<FieldLink> fieldLinks = configuration.getFieldLinks();
        String strLinks = JsonHelper.serialize(fieldLinks);
        storageConf.put("attributeLinks", strLinks);
        Boolean allowToDeleteReq = configuration.getAllowToDeleteReq();
        String strBool = JsonHelper.serialize((Object)allowToDeleteReq);
        storageConf.put("allowToDeleteReq", strBool);
        String valueMapping = configuration.getYamlFieldvalueMapping();
        storageConf.put("valuesMapping", valueMapping);
        this.projectManager.setPluginConfiguration(projectId.longValue(), WorkspaceType.REQUIREMENT_WORKSPACE, "squash.tm.plugin.redminereq", storageConf);
    }

    public Configuration getConfigurationForProject(Long projectId) {
        Configuration configuration;
        block20: {
            Map conf;
            block19: {
                block18: {
                    block17: {
                        String strLinks;
                        block16: {
                            conf = this.projectManager.getPluginConfiguration(projectId.longValue(), WorkspaceType.REQUIREMENT_WORKSPACE, "squash.tm.plugin.redminereq");
                            configuration = new Configuration();
                            String strSrvId = (String)conf.get("serverId");
                            Long serverId = strSrvId != null ? Long.parseLong(strSrvId) : 0L;
                            configuration.setServerId(serverId);
                            String strFilters = (String)conf.get("filterBinding");
                            if (strFilters != null) {
                                try {
                                    Collection bindings = (Collection)this.jsonifier.readValue(strFilters, (TypeReference)new TypeReference<Set<FilterBinding>>(){});
                                    configuration.setFilterBindings(bindings);
                                }
                                catch (IOException e) {
                                    if (!LOGGER.isErrorEnabled()) break block16;
                                    LOGGER.error("could not parse filter binding " + strFilters + FOR_PROJECT + projectId, (Throwable)e);
                                }
                            }
                        }
                        if ((strLinks = (String)conf.get("attributeLinks")) == null) {
                            strLinks = "[]";
                        }
                        try {
                            List links = (List)this.jsonifier.readValue(strLinks, (TypeReference)new TypeReference<List<FieldLink>>(){});
                            if ("[]".equals(strLinks)) {
                                links.add(FieldLink.byId("PARENT"));
                                links.add(FieldLink.byId("RELATES"));
                                links.add(FieldLink.byId("DUPLICATES"));
                                links.add(FieldLink.byId("BLOCKS"));
                                links.add(FieldLink.byId("PRECEDES"));
                                links.add(FieldLink.byId("COPIED"));
                            }
                            configuration.setFieldLinks(links);
                        }
                        catch (IOException e) {
                            if (!LOGGER.isErrorEnabled()) break block17;
                            LOGGER.error("could not parse field link " + strLinks + FOR_PROJECT, (Throwable)e);
                        }
                    }
                    String strBool = (String)conf.get("allowToDeleteReq");
                    if (strBool == null) {
                        strBool = "false";
                    }
                    try {
                        boolean allowToDeleteReq = (Boolean)this.jsonifier.readValue(strBool, (TypeReference)new TypeReference<Boolean>(){});
                        configuration.setAllowToDeleteReq(allowToDeleteReq);
                    }
                    catch (IOException e) {
                        if (!LOGGER.isErrorEnabled()) break block18;
                        LOGGER.error("could not parse field option " + strBool + FOR_PROJECT, (Throwable)e);
                    }
                }
                String strMappings = (String)conf.get("attributeMappings");
                if (strMappings == null) {
                    strMappings = "[]";
                }
                try {
                    this.restoreMappings(configuration, strMappings);
                }
                catch (IOException e) {
                    if (!LOGGER.isErrorEnabled()) break block19;
                    LOGGER.error("could not parse field mapping " + strMappings + FOR_PROJECT, (Throwable)e);
                }
            }
            String strValMappings = (String)conf.get("valuesMapping");
            if (strValMappings == null) {
                strValMappings = "";
            }
            try {
                this.restoreValueMappings(configuration, strValMappings);
            }
            catch (ScannerException ex) {
                if (!LOGGER.isErrorEnabled()) break block20;
                LOGGER.error("could not parse field value mapping " + strValMappings + FOR_PROJECT, (Throwable)ex);
            }
        }
        return configuration;
    }

    private void restoreMappings(Configuration conf, String strMappings) throws IOException {
        List mappings = (List)this.jsonifier.readValue(strMappings, (TypeReference)new TypeReference<List<FieldMapping>>(){});
        List<FieldMapping> basicMapping = FieldMapping.getBuiltinMapping();
        for (FieldMapping m : basicMapping) {
            boolean exists = mappings.contains(m);
            if (exists) continue;
            mappings.add(m);
        }
        conf.setFieldMappings(mappings);
    }

    private void restoreValueMappings(Configuration conf, String stryaml) throws ScannerException {
        Yaml yaml = new Yaml();
        yaml.load(stryaml);
        conf.setYamlFieldvalueMapping(stryaml);
    }

    public Map<String, String> findKnownRequirements(Collection<String> keys, Long projectId) {
        Session session = this.getSession();
        HashMap<String, String> result = new HashMap<String, String>();
        if (keys.isEmpty()) {
            return result;
        }
        List idsList = session.createQuery(ID_AND_KEY_BY_KEY).setParameterList("keys", keys, (Type)StringType.INSTANCE).setParameter("projectId", (Object)projectId).list();
        Map<Long, String> idsMap = this.tupleToMap(idsList);
        if (idsMap.keySet().isEmpty()) {
            return result;
        }
        List pathList = session.getNamedQuery("RequirementPathEdge.findPathsByIds").setParameterList("nodeIds", idsMap.keySet()).list();
        Map<Long, String> pathById = this.tupleToMap(pathList);
        for (Map.Entry<Long, String> entry : pathById.entrySet()) {
            Long id = entry.getKey();
            String path = entry.getValue();
            path = path.replace("/", "\\/").replace("\u001f", "/");
            String key = idsMap.get(id);
            result.put(key, path);
        }
        return result;
    }

    public List<String> findKeysForBinding(FilterBinding binding) {
        QRequirementSyncExtender sync = QRequirementSyncExtender.requirementSyncExtender;
        return ((JPAQuery)((JPAQuery)new JPAQueryFactory(this.em).select((Expression)sync.remoteReqId).from((EntityPath)sync)).where((Predicate)sync.remoteProjectId.eq((Object)binding.getKey()).and((Predicate)sync.remoteFilterName.eq((Object)binding.getFilter())))).fetch();
    }

    public List<Long> retrieveAllDeletableInProject(Long projectId, Collection<String> nonDeletableKeys) {
        QRequirement req = QRequirement.requirement;
        QRequirementSyncExtender sync = QRequirementSyncExtender.requirementSyncExtender;
        return ((JPAQuery)((JPAQuery)((JPAQuery)new JPAQueryFactory(this.em).select((Expression)req.id).from((EntityPath)req)).innerJoin((EntityPath)req.syncExtender, (Path)sync)).where((Predicate)req.project.id.eq((Object)projectId).and((Predicate)sync.remoteReqId.notIn(nonDeletableKeys)).and((Predicate)sync.server.kind.eq((Object)REDMINE3_SERVER_KIND)))).fetch();
    }

    public Map<Long, Set<Long>> versionAndMilestoneIdsByRemoteKeys(Collection<String> remoteKeys, Long projectId) {
        if (remoteKeys.isEmpty()) {
            return new HashMap<Long, Set<Long>>();
        }
        QRequirement req = QRequirement.requirement;
        QRequirementSyncExtender sync = QRequirementSyncExtender.requirementSyncExtender;
        QMilestone mile = QMilestone.milestone;
        QRequirementVersion vers = QRequirementVersion.requirementVersion;
        QProject proj = QProject.project1;
        return (Map)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)new JPAQueryFactory(this.em).select((Expression)vers.id).from((EntityPath)sync)).innerJoin((EntityPath)sync.requirement, (Path)req)).innerJoin((EntityPath)req.resource, (Path)vers)).innerJoin((EntityPath)req.project, (Path)proj)).innerJoin((CollectionExpression)vers.milestones, (Path)mile)).where((Predicate)proj.id.eq((Object)projectId).and((Predicate)sync.remoteReqId.in(remoteKeys)))).groupBy((Expression)vers.id)).groupBy((Expression)mile.id)).transform(GroupBy.groupBy((Expression)vers.id).as((Expression)GroupBy.set((Expression)mile.id)));
    }

    public void deleteLinkedRequirementVersion(Long reqVersionId, List<Long> linkIdsToUnlink) {
        for (Long id : linkIdsToUnlink) {
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(reqVersionId);
            ids.add(id);
            this.em.createNativeQuery("DELETE FROM REQUIREMENT_VERSION_LINK WHERE REQUIREMENT_VERSION_ID IN (:ids) AND RELATED_REQUIREMENT_VERSION_ID IN (:ids) AND REQUIREMENT_VERSION_ID NOT IN (SELECT RES_ID FROM REQUIREMENT_VERSION WHERE REQUIREMENT_STATUS = 'OBSOLETE' OR REQUIREMENT_STATUS = 'APPROVED') AND RELATED_REQUIREMENT_VERSION_ID NOT IN (SELECT RES_ID FROM REQUIREMENT_VERSION WHERE REQUIREMENT_STATUS = 'OBSOLETE' OR REQUIREMENT_STATUS = 'APPROVED')").setParameter("ids", ids).executeUpdate();
        }
    }

    public void removeAllCreationEvent(Collection<Long> versionIds) {
        if (versionIds.isEmpty()) {
            return;
        }
        Query q = this.getSession().createQuery(RMV_CREAT_EVT);
        q.setParameterList("vIds", versionIds, (Type)LongType.INSTANCE);
        q.executeUpdate();
    }

    public void persist(RequirementAuditEvent event) {
        this.getSession().persist((Object)event);
    }

    private Map<Long, String> tupleToMap(List<Object[]> tuples) {
        HashMap<Long, String> res = new HashMap<Long, String>();
        for (Object[] tuple : tuples) {
            res.put((Long)tuple[0], (String)tuple[1]);
        }
        return res;
    }

    private Session getSession() {
        return (Session)this.em.unwrap(Session.class);
    }
}

