/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.redminereq;

import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.squashtest.tm.api.widget.MenuItem;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.plugin.redminereq.RedmineReqMenuItem;
import org.squashtest.tm.plugin.redminereq.RedmineReqPlugin;
import org.squashtest.tm.plugin.redminereq.licensevalidator.LicenseValidator;
import org.squashtest.tm.plugin.redminereq.licensevalidator.service.ValidationService;
import org.squashtest.tm.plugin.redminereq.licensevalidator.service.impl.ValidationServiceImpl;
import org.squashtest.tm.plugin.redminereq.service.PluginDao;
import org.squashtest.tm.web.i18n.InternationalizationHelper;

@Configuration(value="squash.tm.plugin.redminereq.conf")
@ComponentScan(basePackages={"org.squashtest.tm.plugin.redminereq"})
public class SpringConfig {
    @Inject
    private PluginDao dao;
    @Inject
    MessageSource messageSource;
    @Inject
    private InternationalizationHelper langHelper;

    @Bean(name={"squash.tm.plugin.redminereq"})
    public RedmineReqPlugin redmineReqPlugin() {
        RedmineReqPlugin plugin = new RedmineReqPlugin();
        plugin.setDao(this.dao);
        plugin.setLangHelper(this.langHelper);
        RedmineReqMenuItem menuItem = new RedmineReqMenuItem();
        menuItem.setLabelKey("henix.redminereq.synchronization.menu.label");
        menuItem.setTooltipKey("henix.redminereq.synchronization.dialog.preview");
        menuItem.setUrl("plugin/redminereq/synchronize");
        menuItem.setMessageSource(this.messageSource);
        menuItem.afterPropertiesSet();
        plugin.setNameKey("henix.redminereq.plugin.name");
        plugin.setTypeKey("henix.redminereq.plugin.type");
        plugin.setDisplayWorkspace(WorkspaceType.REQUIREMENT_WORKSPACE);
        plugin.setWizardMenu((MenuItem)menuItem);
        return plugin;
    }

    @Bean(name={"org.squashtest.tm.plugin.redminereq.ValidationService"})
    public ValidationService validationService() {
        return new ValidationServiceImpl();
    }

    @Bean(name={"org.squashtest.tm.plugin.redminereq.LicenseValidator"})
    public LicenseValidator licenseValidator(@Named(value="org.squashtest.tm.plugin.redminereq.ValidationService") @Named(value="org.squashtest.tm.plugin.redminereq.ValidationService") ValidationService service) {
        return new LicenseValidator(service);
    }
}

