/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.security.ldap;

import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configuration.GlobalAuthenticationConfigurerAdapter;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.squashtest.tm.api.security.authentication.ConditionalOnAuthProviderProperty;
import org.squashtest.tm.plugin.security.ldap.CaseAwareUserDetailsMapper;
import org.squashtest.tm.plugin.security.ldap.LdapAuthenticationProperties;
import org.squashtest.tm.plugin.security.ldap.LdapAuthenticationProviderFactoryBean;
import org.squashtest.tm.plugin.security.ldap.LdapAuthenticationProviderFeatures;
import org.squashtest.tm.plugin.security.ldap.SquashLdapAuthenticationProvider;
import org.squashtest.tm.plugin.security.ldap.UserDetailsServiceLdapAuthoritiesPopulator;
import org.squashtest.tm.service.internal.security.SquashUserDetailsManager;
import org.squashtest.tm.service.security.UserDetailsService;
import org.squashtest.tm.service.user.UserManagerService;

@Configuration
@ConditionalOnAuthProviderProperty(value="ldap")
@EnableConfigurationProperties(value={LdapAuthenticationProperties.class})
public class LdapSecurityConfig {
    @Inject
    private LdapAuthenticationProperties authenticationProperties;
    @Inject
    @Named(value="squashtest.core.security.JdbcUserDetailsManager")
    @Lazy
    private SquashUserDetailsManager userDetailsManager;
    @Inject
    @Named(value="caseAwareUserDetailsMapper.ldap")
    private CaseAwareUserDetailsMapper userDetailsMapper;
    @Inject
    @Lazy
    private UserManagerService userManagerService;

    @Bean(name={"contextSource.ldap"})
    public DefaultSpringSecurityContextSource ldapContextSource() {
        DefaultSpringSecurityContextSource contextSource = new DefaultSpringSecurityContextSource(this.authenticationProperties.getServer().getUrl());
        contextSource.setUserDn(this.authenticationProperties.getServer().getManagerDn());
        contextSource.setPassword(this.authenticationProperties.getServer().getManagerPassword());
        return contextSource;
    }

    @Bean(name={"authenticationProvider.ldap"})
    public LdapAuthenticationProviderFactoryBean ldapAuthenticationProvider() {
        LdapAuthenticationProviderFactoryBean factoryBean = new LdapAuthenticationProviderFactoryBean();
        factoryBean.setActiveAuthenticationProvider("ldap");
        factoryBean.setContextSource((LdapContextSource)this.ldapContextSource());
        factoryBean.setUserDnPatterns(this.authenticationProperties.getUser().getDnPatterns());
        factoryBean.setUserSearchBase(this.authenticationProperties.getUser().getSearchBase());
        factoryBean.setUserSearchFilter(this.authenticationProperties.getUser().getSearchFilter());
        factoryBean.setFetchUserAttributes(this.authenticationProperties.getUser().isFetchAttributes());
        factoryBean.setAuthoritiesPopulator(new UserDetailsServiceLdapAuthoritiesPopulator((UserDetailsService)this.userDetailsManager));
        factoryBean.setUserDetailsMapper(this.userDetailsMapper);
        factoryBean.setFeatures(this.ldapAuthenticationProviderFeatures());
        factoryBean.setUserManagerService(this.userManagerService);
        return factoryBean;
    }

    @Bean
    public LdapAuthenticationProviderFeatures ldapAuthenticationProviderFeatures() {
        return LdapAuthenticationProviderFeatures.INSTANCE;
    }

    @Configuration
    @ConditionalOnAuthProviderProperty(value="ldap")
    @Order(value=1)
    public static class LdapAuthenticationConfig
    extends GlobalAuthenticationConfigurerAdapter {
        @Inject
        @Named(value="authenticationProvider.ldap")
        private SquashLdapAuthenticationProvider ldapAuthenticationProvider;

        public void configure(AuthenticationManagerBuilder auth) throws Exception {
            auth.authenticationProvider((AuthenticationProvider)this.ldapAuthenticationProvider);
            auth.eraseCredentials(false);
        }
    }
}

