-- *********************************************************************
-- Update Database Script
-- *********************************************************************
-- Change Log: upgrade.changelog-up-to-4.0.0.xml
-- Ran at: 03/12/2025 17:50
-- Against: squashtm@jdbc:postgresql://postgres/squashtest
-- Liquibase version: 4.19.0
-- *********************************************************************

-- Lock Database
UPDATE databasechangeloglock SET LOCKED = TRUE, LOCKEDBY = 'runner-yfpexrfv8-project-33554404-concurrent-0-ltb56xtz (100.64.9.58)', LOCKGRANTED = NOW() WHERE ID = 1 AND LOCKED = FALSE;

-- Changeset ../tm/tm.changelog-4.0.0.xml::tm-4.0.0-SQUASH-5232-add-databasechangelog-new-columns::jprioux
-- Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table
ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS CONTEXTS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS LABELS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS DEPLOYMENT_ID VARCHAR(10) DEFAULT NULL;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', '../tm/tm.changelog-4.0.0.xml', NOW(), 1, '8:aeea36396a9ec2a5a73082a8a593b123', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', 'EXECUTED', NULL, NULL, '4.19.0', '4780606952');

-- Changeset ../tm/tm.changelog-4.0.0.xml::tm-4.0.0::jlor
-- Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '4.0.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0', 'jlor', '../tm/tm.changelog-4.0.0.xml', NOW(), 2, '8:025f887ac0f9e3e270627db101013aa0', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, NULL, '4.19.0', '4780606952');

-- Changeset ../tm/tm.changelog-4.0.0.xml::tm-4.0.0-squash-4931-projects-data-migration::jlor
-- Migrate PROJECT.BDD_IMPLEMENTATION_TECHNOLOGY from value 'CUCUMBER' to 'CUCUMBER_4'
UPDATE PROJECT SET BDD_IMPLEMENTATION_TECHNOLOGY = 'CUCUMBER_4' WHERE BDD_IMPLEMENTATION_TECHNOLOGY = 'CUCUMBER';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-squash-4931-projects-data-migration', 'jlor', '../tm/tm.changelog-4.0.0.xml', NOW(), 3, '8:475f0a521671864f5e605ab2289c8831', 'update tableName=PROJECT', 'Migrate PROJECT.BDD_IMPLEMENTATION_TECHNOLOGY from value ''CUCUMBER'' to ''CUCUMBER_4''', 'EXECUTED', NULL, NULL, '4.19.0', '4780606952');

-- Changeset ../tm/tm.changelog-4.0.0.xml::tm-4.0.0-squash-4931-projects-default-value-modification::jlor
-- Modify default value of PROJECT.BDD_IMPLEMENTATION_TECHNOLOGY from value 'CUCUMBER' to 'CUCUMBER_5_PLUS'
ALTER TABLE PROJECT ALTER COLUMN  BDD_IMPLEMENTATION_TECHNOLOGY SET DEFAULT 'CUCUMBER_5_PLUS';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-squash-4931-projects-default-value-modification', 'jlor', '../tm/tm.changelog-4.0.0.xml', NOW(), 4, '8:2c1b71469d4348feecc17ae521bbc030', 'addDefaultValue columnName=BDD_IMPLEMENTATION_TECHNOLOGY, tableName=PROJECT', 'Modify default value of PROJECT.BDD_IMPLEMENTATION_TECHNOLOGY from value ''CUCUMBER'' to ''CUCUMBER_5_PLUS''', 'EXECUTED', NULL, NULL, '4.19.0', '4780606952');

-- Changeset ../tm/tm.changelog-4.0.0.xml::tm-4.0.0-squash-4931-action-words-data-migration::jlor
-- Migrate ACTION_WORD.LAST_IMPLEMENTATION_TECHNOLOGY from value 'CUCUMBER' to 'CUCUMBER_4'
UPDATE ACTION_WORD SET LAST_IMPLEMENTATION_TECHNOLOGY = 'CUCUMBER_4' WHERE LAST_IMPLEMENTATION_TECHNOLOGY = 'CUCUMBER';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-squash-4931-action-words-data-migration', 'jlor', '../tm/tm.changelog-4.0.0.xml', NOW(), 5, '8:0b655a20f2467fba73a1e177ca742c28', 'update tableName=ACTION_WORD', 'Migrate ACTION_WORD.LAST_IMPLEMENTATION_TECHNOLOGY from value ''CUCUMBER'' to ''CUCUMBER_4''', 'EXECUTED', NULL, NULL, '4.19.0', '4780606952');

-- Changeset ../tm/tm.changelog-4.0.0.xml::tm-4.0.0-squash-5025-token-auth-migration-for-mantis::bms
-- Migrate BASIC_AUTH TO TOKEN_AUTH in third_party_server table
UPDATE THIRD_PARTY_SERVER server
      SET AUTH_PROTOCOL = 'TOKEN_AUTH'
      FROM BUGTRACKER bt
      WHERE bt.KIND = 'mantis' AND server.SERVER_ID = bt.BUGTRACKER_ID;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-squash-5025-token-auth-migration-for-mantis', 'bms', '../tm/tm.changelog-4.0.0.xml', NOW(), 6, '8:1c1973469caaf79e2490e5882bdea0ad', 'sql', 'Migrate BASIC_AUTH TO TOKEN_AUTH in third_party_server table', 'EXECUTED', NULL, NULL, '4.19.0', '4780606952');

-- Changeset ../tm/tm.changelog-4.0.0.xml::tm-4.0.0-squash-5035-add-owner-column-to-remote-synchronisation::cduvigneau
-- Add Owner Column to REMOTE_SYNCHRONISATION Table
ALTER TABLE REMOTE_SYNCHRONISATION ADD OWNER_ID BIGINT;

ALTER TABLE REMOTE_SYNCHRONISATION ADD CONSTRAINT fk_remote_sync_owner FOREIGN KEY (OWNER_ID) REFERENCES CORE_USER (PARTY_ID);

CREATE INDEX idx_fk_remote_sync_owner ON REMOTE_SYNCHRONISATION(OWNER_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-squash-5035-add-owner-column-to-remote-synchronisation', 'cduvigneau', '../tm/tm.changelog-4.0.0.xml', NOW(), 7, '8:40f17eb9122b6900038675ec503289e9', 'addColumn tableName=REMOTE_SYNCHRONISATION; createIndex indexName=idx_fk_remote_sync_owner, tableName=REMOTE_SYNCHRONISATION', 'Add Owner Column to REMOTE_SYNCHRONISATION Table', 'EXECUTED', NULL, NULL, '4.19.0', '4780606952');

-- Changeset ../tm/tm.changelog-4.0.0.xml::tm-4.0.0-delete-column-test-case-version::jlor
-- Delete TEST_CASE.VERSION which is not and was never used
ALTER TABLE TEST_CASE DROP COLUMN VERSION;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-delete-column-test-case-version', 'jlor', '../tm/tm.changelog-4.0.0.xml', NOW(), 8, '8:159df6b73e57c91cc93be6589b236122', 'dropColumn columnName=VERSION, tableName=TEST_CASE', 'Delete TEST_CASE.VERSION which is not and was never used', 'EXECUTED', NULL, NULL, '4.19.0', '4780606952');

-- Changeset ../tm/tm.changelog-4.0.0.xml::tm-4.0.0-sqmap-879-automation-environment-tag::jlor
-- Create table AUTOMATION_ENVIRONMENT_TAG
CREATE TABLE AUTOMATION_ENVIRONMENT_TAG (VALUE VARCHAR(255), ENTITY_TYPE VARCHAR(50) NOT NULL, ENTITY_ID BIGINT NOT NULL);

ALTER TABLE AUTOMATION_ENVIRONMENT_TAG ADD CONSTRAINT uniq_value_entity_type_entity_id UNIQUE (VALUE, ENTITY_TYPE, ENTITY_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-sqmap-879-automation-environment-tag', 'jlor', '../tm/tm.changelog-4.0.0.xml', NOW(), 9, '8:2a3fc3b94331a522eaf3fd685c97773a', 'createTable tableName=AUTOMATION_ENVIRONMENT_TAG; addUniqueConstraint constraintName=uniq_value_entity_type_entity_id, tableName=AUTOMATION_ENVIRONMENT_TAG', 'Create table AUTOMATION_ENVIRONMENT_TAG', 'EXECUTED', NULL, NULL, '4.19.0', '4780606952');

-- Changeset ../tm/tm.changelog-4.0.0.xml::tm-4.0.0-sqmap-879-add-project-inherits-env-tag-column::pckerneis
ALTER TABLE PROJECT ADD INHERITS_ENVIRONMENT_TAGS BOOLEAN DEFAULT TRUE NOT NULL;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-sqmap-879-add-project-inherits-env-tag-column', 'pckerneis', '../tm/tm.changelog-4.0.0.xml', NOW(), 10, '8:d978baa2a38d4182fe4c50c1da0ab300', 'addColumn tableName=PROJECT', '', 'EXECUTED', NULL, NULL, '4.19.0', '4780606952');

-- Changeset ../tm/tm.changelog-4.0.0.xml::tm-4.0.0-sqmap-879-add-project-level-credentials::pckerneis
ALTER TABLE STORED_CREDENTIALS ADD PROJECT_ID BIGINT DEFAULT null;

ALTER TABLE STORED_CREDENTIALS ADD CONSTRAINT fk_stored_credentials_project FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT (PROJECT_ID);

COMMENT ON COLUMN STORED_CREDENTIALS.PROJECT_ID IS 'Foreign key to the project bound to these credentials. NULL for app-level and user-level credentials.';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-sqmap-879-add-project-level-credentials', 'pckerneis', '../tm/tm.changelog-4.0.0.xml', NOW(), 11, '8:9309f9f9fa4752b65ca68bfb504c872f', 'addColumn tableName=STORED_CREDENTIALS', '', 'EXECUTED', NULL, NULL, '4.19.0', '4780606952');

-- Changeset ../tm/tm.changelog-4.0.0.xml::tm-4.0.0-SQUASH-4923-remove-orphan-project-filters::dclaerhout
DELETE FROM PROJECT_FILTER_ENTRY
      WHERE FILTER_ID in(
          SELECT pf.PROJECT_FILTER_ID
          FROM PROJECT_FILTER AS pf
          LEFT JOIN CORE_USER AS cu ON cu.LOGIN = pf.USER_LOGIN
          WHERE cu.LOGIN IS NULL
      );

DELETE FROM PROJECT_FILTER
      WHERE USER_LOGIN in(
        SELECT * FROM (
                        SELECT pf.USER_LOGIN
                        FROM PROJECT_FILTER AS pf
                               LEFT JOIN CORE_USER AS cu ON cu.LOGIN = pf.USER_LOGIN
                        WHERE cu.LOGIN IS NULL
                      ) AS user_logins
      );

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-SQUASH-4923-remove-orphan-project-filters', 'dclaerhout', '../tm/tm.changelog-4.0.0.xml', NOW(), 12, '8:49763b942b13245884a80c6c3cabce0c', 'sql', '', 'EXECUTED', NULL, NULL, '4.19.0', '4780606952');

-- Changeset ../tm/tm.changelog-4.0.0.xml::tm-4.0.0-squash-5384-taserver-observer-url-column::pckerneis
-- Add OBSERVER_URL column to TEST_AUTOMATION_SERVER
ALTER TABLE TEST_AUTOMATION_SERVER ADD OBSERVER_URL VARCHAR(255) DEFAULT null;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-squash-5384-taserver-observer-url-column', 'pckerneis', '../tm/tm.changelog-4.0.0.xml', NOW(), 13, '8:c2d0bb202997d68a0a96a0c7e3371188', 'addColumn tableName=TEST_AUTOMATION_SERVER', 'Add OBSERVER_URL column to TEST_AUTOMATION_SERVER', 'EXECUTED', NULL, NULL, '4.19.0', '4780606952');

-- Release Database Lock
UPDATE databasechangeloglock SET LOCKED = FALSE, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

