--  *********************************************************************
--  Update Database Script
--  *********************************************************************
--  Change Log: upgrade.changelog-up-to-5.0.0.xml
--  Ran at: 03/12/2025 17:50
--  Against: root@jdbc:mariadb://mariadb/squashtest
--  Liquibase version: 4.19.0
--  *********************************************************************

--  Lock Database
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 1, LOCKEDBY = 'runner-yfpexrfv8-project-33554404-concurrent-0-ltb56xtz (100.64.9.58)', LOCKGRANTED = NOW() WHERE ID = 1 AND `LOCKED` = 0;

--  Changeset ../tm/tm.changelog-5.0.0.xml::tm-5.0.0::bmsaddek
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '5.0.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-5.0.0', 'bmsaddek', '../tm/tm.changelog-5.0.0.xml', NOW(), 1, '8:ddd83a5610bd728072f355a2b538db35', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, NULL, '4.19.0', '4780601063');

--  Changeset ../tm/tm.changelog-5.0.0.xml::tm-5.0.0-SQUASH-5923-increase-max-size-for-databasechangelog::jprioux
--  Increase max size for ID and author columns in databasechangelog table
ALTER TABLE DATABASECHANGELOG MODIFY ID VARCHAR(255);

ALTER TABLE DATABASECHANGELOG MODIFY AUTHOR VARCHAR(255);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-5.0.0-SQUASH-5923-increase-max-size-for-databasechangelog', 'jprioux', '../tm/tm.changelog-5.0.0.xml', NOW(), 2, '8:c07f3378fe9a5eefabb12c39b0fa3a08', 'modifyDataType columnName=ID, tableName=DATABASECHANGELOG; modifyDataType columnName=AUTHOR, tableName=DATABASECHANGELOG', 'Increase max size for ID and author columns in databasechangelog table', 'EXECUTED', NULL, NULL, '4.19.0', '4780601063');

--  Changeset ../tm/tm.changelog-5.0.0.xml::tm-5.0.0-SQUASH-5745-Add-environment-variables-to-project::bmsaddek
--  Add VALUE, ENTITY_TYPE columns to ENVIRONMENT_VARIABLE_BINDING Table
ALTER TABLE ENVIRONMENT_VARIABLE_BINDING ADD ENTITY_ID BIGINT NULL, ADD ENTITY_TYPE VARCHAR(30) NULL, ADD VALUE VARCHAR(255) NULL;

CREATE INDEX idx_evb_entity_id ON ENVIRONMENT_VARIABLE_BINDING(ENTITY_ID);

CREATE INDEX idx_evb_entity_type ON ENVIRONMENT_VARIABLE_BINDING(ENTITY_TYPE);

ALTER TABLE ENVIRONMENT_VARIABLE_BINDING DROP FOREIGN KEY fk_ev_binding_server;

DROP INDEX idx_fk_ev_binding_server ON ENVIRONMENT_VARIABLE_BINDING;

ALTER TABLE ENVIRONMENT_VARIABLE_BINDING DROP KEY uc_ev_server_bnd;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-5.0.0-SQUASH-5745-Add-environment-variables-to-project', 'bmsaddek', '../tm/tm.changelog-5.0.0.xml', NOW(), 3, '8:9f17e23b3e0705d47adc71a2d6c90833', 'addColumn tableName=ENVIRONMENT_VARIABLE_BINDING; createIndex indexName=idx_evb_entity_id, tableName=ENVIRONMENT_VARIABLE_BINDING; createIndex indexName=idx_evb_entity_type, tableName=ENVIRONMENT_VARIABLE_BINDING; dropForeignKeyConstraint baseTabl...', 'Add VALUE, ENTITY_TYPE columns to ENVIRONMENT_VARIABLE_BINDING Table', 'EXECUTED', NULL, NULL, '4.19.0', '4780601063');

--  Changeset ../tm/tm.changelog-5.0.0.xml::tm-5.0.0-SQUASH-5745-environment-variable-data-migration-server-value::lmurat
--  Migrate environment variable values in environment_variable_binding table it's a server value
UPDATE ENVIRONMENT_VARIABLE_BINDING binding
      INNER JOIN ENVIRONMENT_VARIABLE_VALUE environmentvalue ON environmentvalue.EVB_ID = binding.EVB_ID
      SET binding.ENTITY_TYPE = environmentvalue.BOUND_ENTITY_TYPE, binding.ENTITY_ID = environmentvalue.BOUND_ENTITY_ID, binding.VALUE = environmentvalue.VALUE
      WHERE environmentvalue.BOUND_ENTITY_TYPE = 'TEST_AUTOMATION_SERVER';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-5.0.0-SQUASH-5745-environment-variable-data-migration-server-value', 'lmurat', '../tm/tm.changelog-5.0.0.xml', NOW(), 4, '8:5537a8373d62f421d1753c6e536b2c31', 'sql', 'Migrate environment variable values in environment_variable_binding table it''s a server value', 'EXECUTED', NULL, NULL, '4.19.0', '4780601063');

--  Changeset ../tm/tm.changelog-5.0.0.xml::tm-5.0.0-SQUASH-5745-environment-variable-data-migration-default-value::lmurat
--  Migrate environment variable values in environment_variable_binding table when project value doesn't exist in environment variable value table
INSERT INTO ENVIRONMENT_VARIABLE_BINDING (EV_ID, ENTITY_ID, ENTITY_TYPE, VALUE, BOUND_SERVER_ID)
        (SELECT binding.EV_ID, project.PROJECT_ID as ENTITY_ID, 'PROJECT' as ENTITY_TYPE, servervalue.VALUE, binding.BOUND_SERVER_ID as BOUND_SERVER_ID
         FROM ENVIRONMENT_VARIABLE_BINDING binding
                INNER JOIN PROJECT project ON project.TA_SERVER_ID = binding.BOUND_SERVER_ID
                LEFT JOIN ENVIRONMENT_VARIABLE_VALUE servervalue ON servervalue.EVB_ID = binding.EVB_ID AND servervalue.BOUND_ENTITY_TYPE = 'TEST_AUTOMATION_SERVER'
                LEFT JOIN ENVIRONMENT_VARIABLE_VALUE projectvalue ON projectvalue.EVB_ID = binding.EVB_ID AND projectvalue.BOUND_ENTITY_TYPE = 'PROJECT' AND projectvalue.BOUND_ENTITY_ID = project.PROJECT_ID
         WHERE projectvalue.EVB_ID IS NULL);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-5.0.0-SQUASH-5745-environment-variable-data-migration-default-value', 'lmurat', '../tm/tm.changelog-5.0.0.xml', NOW(), 5, '8:7f39425624e0fa1f975a8fca8e3b6437', 'sql', 'Migrate environment variable values in environment_variable_binding table when project value doesn''t exist in environment variable value table', 'EXECUTED', NULL, NULL, '4.19.0', '4780601063');

--  Changeset ../tm/tm.changelog-5.0.0.xml::tm-5.0.0-SQUASH-5745-environment-variable-data-migration-project-value::lmurat
--  Migrate environment variable values in environment_variable_binding table when project value exist in environment variable value table
INSERT INTO ENVIRONMENT_VARIABLE_BINDING (EV_ID, ENTITY_ID, ENTITY_TYPE, VALUE, BOUND_SERVER_ID)
        (SELECT binding.EV_ID, environmentvalue.BOUND_ENTITY_ID as ENTITY_ID, environmentvalue.BOUND_ENTITY_TYPE as ENTITY_TYPE, environmentvalue.VALUE, binding.BOUND_SERVER_ID
         FROM ENVIRONMENT_VARIABLE_BINDING binding
        INNER JOIN ENVIRONMENT_VARIABLE_VALUE environmentvalue ON environmentvalue.EVB_ID = binding.EVB_ID
        WHERE environmentvalue.BOUND_ENTITY_TYPE = 'PROJECT');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-5.0.0-SQUASH-5745-environment-variable-data-migration-project-value', 'lmurat', '../tm/tm.changelog-5.0.0.xml', NOW(), 6, '8:0a01a8b66eadd5c42daa00227460d393', 'sql', 'Migrate environment variable values in environment_variable_binding table when project value exist in environment variable value table', 'EXECUTED', NULL, NULL, '4.19.0', '4780601063');

--  Changeset ../tm/tm.changelog-5.0.0.xml::tm-5.0.0-SQUASH-5745-Drop-environment-variable-value-table::lmurat
--  Drop old environment variable values
ALTER TABLE ENVIRONMENT_VARIABLE_BINDING DROP COLUMN bound_server_id;

DROP TABLE ENVIRONMENT_VARIABLE_VALUE;

ALTER TABLE ENVIRONMENT_VARIABLE_BINDING ADD CONSTRAINT uc_evb_id_type_ev_id_binding UNIQUE (ENTITY_ID, ENTITY_TYPE, EV_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-5.0.0-SQUASH-5745-Drop-environment-variable-value-table', 'lmurat', '../tm/tm.changelog-5.0.0.xml', NOW(), 7, '8:231d11cf680fe71bc8f25eb3df9f0c1b', 'dropColumn columnName=bound_server_id, tableName=ENVIRONMENT_VARIABLE_BINDING; dropTable tableName=ENVIRONMENT_VARIABLE_VALUE; addUniqueConstraint constraintName=uc_evb_id_type_ev_id_binding, tableName=ENVIRONMENT_VARIABLE_BINDING', 'Drop old environment variable values', 'EXECUTED', NULL, NULL, '4.19.0', '4780601063');

--  Changeset ../tm/tm.changelog-5.0.0.xml::tm-5.0.0-SQUASH-5745-Add-environment-variables-type-to-denormalized-environment-variable::bmsaddek
--  Add TYPE column to DENORMALIZED_ENVIRONMENT_VARIABLE Table
ALTER TABLE DENORMALIZED_ENVIRONMENT_VARIABLE ADD TYPE VARCHAR(30) NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-5.0.0-SQUASH-5745-Add-environment-variables-type-to-denormalized-environment-variable', 'bmsaddek', '../tm/tm.changelog-5.0.0.xml', NOW(), 8, '8:1fb134d3b3e63fc03f56419b952cd1cc', 'addColumn tableName=DENORMALIZED_ENVIRONMENT_VARIABLE', 'Add TYPE column to DENORMALIZED_ENVIRONMENT_VARIABLE Table', 'EXECUTED', NULL, NULL, '4.19.0', '4780601063');

--  Changeset ../tm/tm.changelog-5.0.0.xml::tm-5.0.0-SQUASH-5890-environment-variable-data-migration-variable-type::bmsaddek
--  Copy environment variable type in denormalized_environment_variable table if the variable has not been deleted
UPDATE DENORMALIZED_ENVIRONMENT_VARIABLE denormalized
        INNER JOIN ENVIRONMENT_VARIABLE environmentvariable ON environmentvariable.EV_ID = denormalized.EV_ID
      SET denormalized.TYPE = environmentvariable.INPUT_TYPE
      WHERE denormalized.EV_ID IS NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-5.0.0-SQUASH-5890-environment-variable-data-migration-variable-type', 'bmsaddek', '../tm/tm.changelog-5.0.0.xml', NOW(), 9, '8:70a968f47cd20a7dcfaedf26dc408bbc', 'sql', 'Copy environment variable type in denormalized_environment_variable table if the variable has not been deleted', 'EXECUTED', NULL, NULL, '4.19.0', '4780601063');

--  Changeset ../tm/tm.changelog-5.0.0.xml::tm-5.0.0-add-user-custom-delete-permission::pckerneis
--  Add a column for custom delete permissions on CORE_USER table
ALTER TABLE CORE_USER ADD CAN_DELETE_FROM_FRONT BIT(1) DEFAULT 1 NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-5.0.0-add-user-custom-delete-permission', 'pckerneis', '../tm/tm.changelog-5.0.0.xml', NOW(), 10, '8:de173256e065f48609f2a9d900c4575d', 'addColumn tableName=CORE_USER', 'Add a column for custom delete permissions on CORE_USER table', 'EXECUTED', NULL, NULL, '4.19.0', '4780601063');

--  Changeset ../tm/tm.changelog-5.0.0.xml::tm-5.0.0-squash-5665-update-welcome-and-login-message::lmurat
--  Adapt default welcome and login message to new front
UPDATE CORE_CONFIG
      SET VALUE = '<p><span style="color:#ff0000;">The administrator default login is <strong>admin/admin</strong> (you can change this password in the &quot;<em>My account (admin)</em>&quot; menu).</span></p><p>Go to the &quot;<em>Administration&quot;</em> menu (in the bottom left corner) to create new users and projects, or change this default home message.</p><p>&nbsp;</p>'
WHERE STR_KEY = 'LOGIN_MESSAGE' AND VALUE = '<p><span style="color:#ff0000;">The administrator default login is <strong>admin/admin</strong> (you can change this password in the &quot;<em>My account (admin)</em>&quot; menu).</span></p><p>Go to the &quot;<em>Administration&quot;</em> menu (in the upper right corner) to create new users and projects, or change this default home message.</p><p>&nbsp;</p>'
   OR STR_KEY = 'WELCOME_MESSAGE' AND VALUE = '<p><span style="color:#ff0000;">The administrator default login is <strong>admin/admin</strong> (you can change this password in the &quot;<em>My account (admin)</em>&quot; menu).</span></p><p>Go to the &quot;<em>Administration&quot;</em> menu (in the upper right corner) to create new users and projects, or change this default home message.</p><p>&nbsp;</p>';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-5.0.0-squash-5665-update-welcome-and-login-message', 'lmurat', '../tm/tm.changelog-5.0.0.xml', NOW(), 11, '8:c570593a856701eeaef40e261906ca49', 'sql', 'Adapt default welcome and login message to new front', 'EXECUTED', NULL, NULL, '4.19.0', '4780601063');

--  Changeset ../tm/tm.changelog-5.0.0.xml::tm-5.0.0-squash-5881-update-length-for-test-suite-name::lmurat
--  Increase character limit for test suite name to 255
ALTER TABLE TEST_SUITE MODIFY NAME VARCHAR(255);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-5.0.0-squash-5881-update-length-for-test-suite-name', 'lmurat', '../tm/tm.changelog-5.0.0.xml', NOW(), 12, '8:616136c4a235c82336eac693310da3da', 'modifyDataType columnName=NAME, tableName=TEST_SUITE', 'Increase character limit for test suite name to 255', 'EXECUTED', NULL, NULL, '4.19.0', '4780601063');

--  Changeset ../tm/tm.changelog-5.0.0.xml::tm-5.0.0-squash-5384-taserver-eventbus-url-column::pckerneis
--  Add EVENT_BUS_URL column to TEST_AUTOMATION_SERVER
ALTER TABLE TEST_AUTOMATION_SERVER ADD EVENT_BUS_URL VARCHAR(255) DEFAULT null NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-5.0.0-squash-5384-taserver-eventbus-url-column', 'pckerneis', '../tm/tm.changelog-5.0.0.xml', NOW(), 13, '8:91348b0e8aca3f2b2fa893d2294cf5d1', 'addColumn tableName=TEST_AUTOMATION_SERVER', 'Add EVENT_BUS_URL column to TEST_AUTOMATION_SERVER', 'EXECUTED', NULL, NULL, '4.19.0', '4780601063');

--  Changeset ../tm/tm.changelog-5.0.0.xml::tm-5.0.0-squash-5749-add-test-technology-tag-to-automated-execution-extender::lmurat
--  Add the automated test technology tag to the automated execution extender
ALTER TABLE AUTOMATED_EXECUTION_EXTENDER ADD TEST_TECHNOLOGY VARCHAR(36) NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-5.0.0-squash-5749-add-test-technology-tag-to-automated-execution-extender', 'lmurat', '../tm/tm.changelog-5.0.0.xml', NOW(), 14, '8:740bdcd4f3747a8a58221d76e1444adf', 'addColumn tableName=AUTOMATED_EXECUTION_EXTENDER', 'Add the automated test technology tag to the automated execution extender', 'EXECUTED', NULL, NULL, '4.19.0', '4780601063');

--  Release Database Lock
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 0, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

