select R.HIGH_LEVEL_REQUIREMENT_ID as HLRID,
       RES.RES_ID,
       P.NAME as PROJECT_NAME,
       RV.REFERENCE as REFERENCE,
       RES.NAME as NAME,
	   GROUP_CONCAT(case when M.LABEL is not null then concat(M.LABEL, '=Sep=') end) as MILESTONE,
	   RV.CRITICALITY as CRITICALITY,
	   RV.REQUIREMENT_STATUS as STATUS
from RESOURCE RES
join REQUIREMENT_VERSION RV on RES.RES_ID = RV.RES_ID
join REQUIREMENT R on RV.RES_ID = R.CURRENT_VERSION_ID
join REQUIREMENT_LIBRARY_NODE on R.RLN_ID = REQUIREMENT_LIBRARY_NODE.RLN_ID
join PROJECT P on REQUIREMENT_LIBRARY_NODE.PROJECT_ID = P.PROJECT_ID
left join MILESTONE_REQ_VERSION MRV on RV.RES_ID = MRV.REQ_VERSION_ID
left join MILESTONE M on MRV.MILESTONE_ID = M.MILESTONE_ID
where R.HIGH_LEVEL_REQUIREMENT_ID in (:hlrIds)
group by R.HIGH_LEVEL_REQUIREMENT_ID, RES.RES_ID, RV.CRITICALITY, P.NAME, RV.REFERENCE, RES.NAME, RV.RES_ID
order by R.HIGH_LEVEL_REQUIREMENT_ID, RV.CRITICALITY, P.NAME, RV.REFERENCE, RES.NAME
