/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.legacybooks.testcases.query;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.squashtest.tm.api.repository.SqlQueryRunner;

public class TestCasesTreeQueryFinder {
    private static final String TAGS = "tags";
    private static final String MILESTONES = "milestones";
    private static final String ENTITY_TYPE = "entityType";
    private static final String ENTITY_IDS = "entityIds";
    private static final String PROJECT_IDS = "projectIds";
    private static final String NODE_IDS = "nodeIds";
    private static final String TEST_CASE_IDS = "testcaseIds";
    private static final String TEST_CASE_ID = "testcaseId";
    private String idsByProjectQuery;
    private String idsBySelectionQuery;
    private String idsByMilestoneQuery;
    private String idsByTagQuery;
    private String testCasesQuery;
    private String linkedReqQuery;
    private String testCaseStepsQuery;
    private String cufQuery;
    private String rtfCufQuery;
    private String tagCufQuery;
    private String numCufQuery;
    private String nodesByTestCaseIdsQuery;
    private String nodesByMilestonesQuery;
    private String nodesByTagsQuery;
    private String nodesByProjectIdsQuery;
    private String testStepsByCallSteps;
    private String parametersQuery;
    private String dataSetQuery;
    private String dataSetParamValueQuery;
    SqlQueryRunner runner;

    void setIdsByProjectQuery(String idsByProjectQuery) {
        this.idsByProjectQuery = idsByProjectQuery;
    }

    void setIdsBySelectionQuery(String idsBySelectionQuery) {
        this.idsBySelectionQuery = idsBySelectionQuery;
    }

    void setIdsByMilestoneQuery(String idsByMilestoneQuery) {
        this.idsByMilestoneQuery = idsByMilestoneQuery;
    }

    void setIdsByTagQuery(String idsByTagQuery) {
        this.idsByTagQuery = idsByTagQuery;
    }

    void setRunner(SqlQueryRunner runner) {
        this.runner = runner;
    }

    void setTestCasesQuery(String testCasesQuery) {
        this.testCasesQuery = testCasesQuery;
    }

    void setTestCaseStepsQuery(String testCaseStepsQuery) {
        this.testCaseStepsQuery = testCaseStepsQuery;
    }

    void setLinkedReqQuery(String linkedReqQuery) {
        this.linkedReqQuery = linkedReqQuery;
    }

    void setCufQuery(String cufQuery) {
        this.cufQuery = cufQuery;
    }

    void setRtfCufQuery(String rtfCufQuery) {
        this.rtfCufQuery = rtfCufQuery;
    }

    void setTagCufQuery(String tagCufQuery) {
        this.tagCufQuery = tagCufQuery;
    }

    void setNumCufQuery(String numCufQuery) {
        this.numCufQuery = numCufQuery;
    }

    void setNodesByTestCaseIdsQuery(String nodesByTestCaseIdsQuery) {
        this.nodesByTestCaseIdsQuery = nodesByTestCaseIdsQuery;
    }

    void setNodesByMilestonesQuery(String nodesByMilestonesQuery) {
        this.nodesByMilestonesQuery = nodesByMilestonesQuery;
    }

    void setNodesByTagsQuery(String nodesByTagsQuery) {
        this.nodesByTagsQuery = nodesByTagsQuery;
    }

    void setNodesByProjectIdsQuery(String nodesByProjectIdsQuery) {
        this.nodesByProjectIdsQuery = nodesByProjectIdsQuery;
    }

    void setTestStepsByCallSteps(String testStepsByCallSteps) {
        this.testStepsByCallSteps = testStepsByCallSteps;
    }

    void setParametersQuery(String parametersQuery) {
        this.parametersQuery = parametersQuery;
    }

    void setDataSetQuery(String dataSetQuery) {
        this.dataSetQuery = dataSetQuery;
    }

    void setDataSetParamValueQuery(String dataSetParamValueQuery) {
        this.dataSetParamValueQuery = dataSetParamValueQuery;
    }

    Collection<Long> findIdsByProject(List<Long> projectIds) {
        if (CollectionUtils.isEmpty(projectIds)) {
            return Collections.emptyList();
        }
        HashMap<String, List<Long>> params = new HashMap<String, List<Long>>(1);
        params.put(PROJECT_IDS, projectIds);
        List foundStrIds = this.runner.executeSelect(this.idsByProjectQuery, params);
        return this.toIdList(foundStrIds);
    }

    Collection<Long> findIdsBySelection(Collection<String> ids, List<Long> projectIds) {
        LinkedList<Long> versionIds = new LinkedList();
        if (ids != null && !ids.isEmpty()) {
            HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>(1);
            params.put(NODE_IDS, this.toIdList(ids));
            params.put(PROJECT_IDS, projectIds);
            List foundStrIds = this.runner.executeSelect(this.idsBySelectionQuery, params);
            versionIds.addAll(this.toIdList(foundStrIds));
        } else {
            versionIds = new ArrayList();
        }
        return versionIds;
    }

    Collection<Long> findIdsByMilestone(Collection<String> milestoneIds, List<Long> projectIds) {
        if (!milestoneIds.isEmpty()) {
            HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>();
            params.put(MILESTONES, this.toIdList(milestoneIds));
            params.put(PROJECT_IDS, projectIds);
            List foundIds = this.runner.executeSelect(this.idsByMilestoneQuery, params);
            return this.toIdList(foundIds);
        }
        return Collections.emptyList();
    }

    Collection<Long> findIdsByTags(Collection<String> tags, List<Long> projectIds) {
        if (!tags.isEmpty()) {
            HashMap<String, Collection<Object>> params = new HashMap<String, Collection<Object>>();
            params.put(TAGS, tags);
            params.put(PROJECT_IDS, projectIds);
            List foundIds = this.runner.executeSelect(this.idsByTagQuery, params);
            return this.toIdList(foundIds);
        }
        return Collections.emptyList();
    }

    Collection<Object[]> getTestCasesData(Collection<Long> testCaseIds) {
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>();
        params.put(TEST_CASE_IDS, testCaseIds);
        return this.execute(this.testCasesQuery, params);
    }

    Collection<Object[]> getLinkedReqData(Collection<Long> testCaseIds) {
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>();
        params.put(TEST_CASE_IDS, testCaseIds);
        return this.execute(this.linkedReqQuery, params);
    }

    Collection<Object[]> getTestCaseStepsData(Collection<Long> testCaseIds) {
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>();
        params.put(TEST_CASE_IDS, testCaseIds);
        return this.execute(this.testCaseStepsQuery, params);
    }

    Collection<Object[]> getCufData(String entityType, Collection<Long> entityIds) {
        return this.executeCufQuery(entityType, entityIds, this.cufQuery);
    }

    Collection<Object[]> getNumCufData(String entityType, Collection<Long> entityIds) {
        return this.executeCufQuery(entityType, entityIds, this.numCufQuery);
    }

    Collection<Object[]> getRtfCufData(String entityType, Collection<Long> entityIds) {
        return this.executeCufQuery(entityType, entityIds, this.rtfCufQuery);
    }

    Collection<Object[]> getTagCufData(String entityType, Collection<Long> entityIds) {
        return this.executeCufQuery(entityType, entityIds, this.tagCufQuery);
    }

    Collection<Object[]> executeCufQuery(String entityType, Collection<Long> entityIds, String query) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ENTITY_TYPE, entityType);
        params.put(ENTITY_IDS, entityIds);
        return this.execute(query, params);
    }

    Collection<Object[]> getNodesByTestCasesIds(Collection<String> testCaseIds, List<Long> projectIds) {
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>(1);
        params.put(NODE_IDS, this.toIdList(testCaseIds));
        params.put(PROJECT_IDS, projectIds);
        return this.execute(this.nodesByTestCaseIdsQuery, params);
    }

    Collection<Object[]> getNodesByMilestones(Collection<String> milestones, List<Long> projectIds) {
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>();
        params.put(MILESTONES, this.toIdList(milestones));
        params.put(PROJECT_IDS, projectIds);
        return this.execute(this.nodesByMilestonesQuery, params);
    }

    Collection<Object[]> getNodesTags(Collection<String> tags, List<Long> projectIds) {
        HashMap<String, Collection<Object>> params = new HashMap<String, Collection<Object>>();
        params.put(TAGS, tags);
        params.put(PROJECT_IDS, projectIds);
        return this.execute(this.nodesByTagsQuery, params);
    }

    Collection<Object[]> getNodesByProjectIds(List<Long> projectIds) {
        HashMap<String, List<Long>> params = new HashMap<String, List<Long>>(1);
        params.put(PROJECT_IDS, projectIds);
        return this.execute(this.nodesByProjectIdsQuery, params);
    }

    Collection<Object[]> getTestCaseStepsData(Long testCaseId) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put(TEST_CASE_ID, testCaseId);
        return this.execute(this.testStepsByCallSteps, params);
    }

    Collection<Object[]> getParametersData(Collection<Long> testCaseIds) {
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>();
        params.put(TEST_CASE_IDS, testCaseIds);
        return this.execute(this.parametersQuery, params);
    }

    Collection<Object[]> getDataSetData(Collection<Long> testCaseIds) {
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>();
        params.put(TEST_CASE_IDS, testCaseIds);
        return this.execute(this.dataSetQuery, params);
    }

    Collection<Object[]> getDataSetParamValueData(Collection<Long> testCaseIds) {
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>();
        params.put(TEST_CASE_IDS, testCaseIds);
        return this.execute(this.dataSetParamValueQuery, params);
    }

    private Collection<Object[]> execute(String query, Map<String, ?> params) {
        return this.runner.executeSelect(query, params);
    }

    Collection<Long> toIdList(Collection<?> ids) {
        return CollectionUtils.collect(ids, (Transformer)new IdTransformer());
    }

    private static class IdTransformer
    implements Transformer {
        private IdTransformer() {
        }

        public Object transform(Object arg0) {
            Class<?> argClass = arg0.getClass();
            if (argClass.equals(String.class)) {
                return Long.valueOf((String)arg0);
            }
            if (argClass.equals(BigInteger.class)) {
                return ((BigInteger)arg0).longValue();
            }
            if (argClass.equals(Integer.class)) {
                return (long)((Integer)arg0).intValue();
            }
            throw new RuntimeException("bug : IdTransformer cannto convert items of class " + argClass.getName());
        }
    }
}

