/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.legacybooks.requirements.dto;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.plugin.report.legacybooks.requirements.dto.RequirementVersionData;

public class FolderData {
    private static final String BREADCRUMB_SEPARATOR = " > ";
    private String name = "";
    private String description;
    private Long folderId;
    private Long ancestorId;
    private Long projectId;
    private FolderData parent;
    private String breadcrumb;
    private String index = null;
    private boolean pseudoRoot = false;
    private List<FolderData> folders = new LinkedList<FolderData>();
    private List<RequirementVersionData> requirementVersions = new LinkedList<RequirementVersionData>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getFolderId() {
        return this.folderId;
    }

    public void setFolderId(Long folderId) {
        this.folderId = folderId;
    }

    public Long getAncestorId() {
        return this.ancestorId;
    }

    public void setAncestorId(Long ancestorId) {
        this.ancestorId = ancestorId;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public boolean isPseudoRoot() {
        return this.pseudoRoot;
    }

    public void setPseudoRoot(boolean pseudo) {
        this.pseudoRoot = pseudo;
    }

    public void sortContent() {
        Collections.sort(this.folders, new FolderSorter());
        Collections.sort(this.requirementVersions, new VersionSorter());
    }

    public FolderData getParent() {
        return this.parent;
    }

    public void setParent(FolderData parent) {
        this.parent = parent;
    }

    public List<FolderData> getFolders() {
        return this.folders;
    }

    public List<RequirementVersionData> getRequirementVersions() {
        return this.requirementVersions;
    }

    public void addContent(FolderData folder) {
        this.folders.add(folder);
    }

    public void addContent(RequirementVersionData version) {
        this.requirementVersions.add(version);
        this.requirementVersions.addAll(version.getAllChildren());
    }

    public String getBreadcrumb() {
        if (this.breadcrumb == null) {
            this.breadcrumb = this.isPseudoRoot() || this.parent.isPseudoRoot() ? this.name : String.valueOf(this.parent.getBreadcrumb()) + BREADCRUMB_SEPARATOR + this.name;
        }
        return this.breadcrumb;
    }

    public String getIndex() {
        if (this.index == null) {
            this.index = this.isPseudoRoot() ? "" : this.getParent()._tellMyIndex(this);
        }
        return this.index;
    }

    private String _tellMyIndex(FolderData son) {
        String sonRank = Integer.valueOf(this.folders.indexOf(son) + 1).toString();
        if (this.isPseudoRoot()) {
            return sonRank;
        }
        return String.valueOf(this.getIndex()) + "." + sonRank;
    }

    public boolean hasAncestor() {
        return this.ancestorId != null;
    }

    public boolean acceptsAsContent(FolderData content) {
        if (content == this) {
            return false;
        }
        if (this.isPseudoRoot()) {
            return !content.hasAncestor() && content.projectId.equals(this.projectId);
        }
        return content.hasAncestor() && content.ancestorId.equals(this.folderId);
    }

    public boolean acceptsAsContent(RequirementVersionData content) {
        if (this.isPseudoRoot()) {
            return !content.hasParentFolder() && !content.hasParentRequirementVersion() && content.getProjectId().equals(this.projectId);
        }
        return content.hasParentFolder() && content.getParentFolderId().equals(this.folderId);
    }

    private static class FolderSorter
    implements Comparator<FolderData> {
        private FolderSorter() {
        }

        @Override
        public int compare(FolderData arg0, FolderData arg1) {
            return arg0.getName().compareTo(arg1.getName());
        }
    }

    private static class VersionSorter
    implements Comparator<RequirementVersionData> {
        private VersionSorter() {
        }

        @Override
        public int compare(RequirementVersionData o1, RequirementVersionData o2) {
            int order = this.compareByName(o1, o2);
            if (order == 0) {
                order = this.compareById(o1, o2);
            }
            if (order == 0) {
                order = this.compareByVersion(o1, o2);
            }
            return order;
        }

        private int compareByName(RequirementVersionData o1, RequirementVersionData o2) {
            String name1 = this.normalizeName(o1);
            String name2 = this.normalizeName(o2);
            return name1.compareTo(name2);
        }

        private int compareById(RequirementVersionData o1, RequirementVersionData o2) {
            return o1.getRequirementId().compareTo(o2.getRequirementId());
        }

        private int compareByVersion(RequirementVersionData o1, RequirementVersionData o2) {
            return o1.getVersionNumber().compareTo(o2.getVersionNumber());
        }

        private String normalizeName(RequirementVersionData data) {
            if (StringUtils.isNotBlank((CharSequence)data.getReference())) {
                return String.valueOf(data.getReference()) + " - " + data.getName();
            }
            return data.getName();
        }
    }
}

