/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.converters.TuleapToSquashConverter;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapResource;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapTracker;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TuleapProject {
    @JsonProperty
    private Long id;
    @JsonProperty
    private String label;
    @JsonProperty(value="shortname")
    private String shortName;
    @JsonProperty(value="resources")
    private List<TuleapResource> resources = new ArrayList<TuleapResource>();
    @JsonIgnore
    private List<TuleapTracker> trackers;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public List<TuleapResource> getResources() {
        return this.resources;
    }

    public void setResources(List<TuleapResource> resources) {
        this.resources = resources;
    }

    public List<TuleapTracker> getTrackers() {
        return this.trackers;
    }

    public void setTrackers(List<TuleapTracker> trackers) {
        this.trackers = trackers;
    }

    public String getTrackersUri() {
        return this.resources.stream().filter(TuleapResource::isTrackerResource).findFirst().get().getUri();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("TuleapProject{");
        sb.append("id=").append(this.id);
        sb.append(", label='").append(this.label).append('\'');
        sb.append(", shortName='").append(this.shortName).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public TuleapTracker findTrackerBySchemeName(String currentScheme) {
        Optional<TuleapTracker> tracker = this.trackers.stream().filter(tuleapTracker -> {
            String schemeName = TuleapToSquashConverter.getSchemeName(tuleapTracker);
            return schemeName.equals(currentScheme);
        }).findFirst();
        return tracker.orElseThrow(() -> new IllegalArgumentException("Unknown Tracker for scheme : " + currentScheme + " for project " + this.getLabel()));
    }

    public TuleapTracker findTrackerById(Long id) {
        Optional<TuleapTracker> tracker = this.trackers.stream().filter(tuleapTracker -> Objects.equals(tuleapTracker.getId(), id)).findFirst();
        return tracker.orElseThrow(() -> new IllegalArgumentException("Unknown Tracker : " + id + " for project " + this.getLabel()));
    }
}

