/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.openid.connect;

import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.annotation.authentication.configuration.AuthenticationConfiguration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2LoginConfigurer;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.oauth2.client.web.AuthorizationRequestRepository;
import org.springframework.security.oauth2.client.web.HttpSessionOAuth2AuthorizationRequestRepository;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.squashtest.tm.plugin.openid.connect.EnableOAuth2Condition;
import org.squashtest.tm.plugin.openid.connect.bean.SquashOidcGrantedAuthoritiesMapper;
import org.squashtest.tm.plugin.openid.connect.properties.OidcAccessProperties;

@Configuration
@Conditional(value={EnableOAuth2Condition.class})
@EnableAutoConfiguration
@EnableConfigurationProperties(value={OidcAccessProperties.class})
public class OidcConfig {
    private static final String AUTHORIZATION_ENDPOINT = "/oidc/authorization/";
    private static final String REDIRECTION_ENDPOINT = "/oidc/code/*";

    @Bean
    public AuthenticationManager oidcAuthenticationManager(AuthenticationConfiguration authenticationConfiguration) throws Exception {
        AuthenticationManager manager = authenticationConfiguration.getAuthenticationManager();
        if (manager instanceof ProviderManager var3_4) {
            providerManager.setEraseCredentialsAfterAuthentication(true);
            return providerManager;
        }
        return manager;
    }

    @Bean
    @Order(value=29)
    public SecurityFilterChain oidcSecurityFilterChain(HttpSecurity http) throws Exception {
        http.csrf(AbstractHttpConfigurer::disable).antMatcher("/oidc/**").authorizeRequests(authz -> {
            ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry = ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)authz.anyRequest()).authenticated();
        }).oauth2Login(oauthLogin -> {
            OAuth2LoginConfigurer oAuth2LoginConfigurer = ((OAuth2LoginConfigurer)((OAuth2LoginConfigurer)oauthLogin.successHandler((AuthenticationSuccessHandler)this.oidcAuthenticationSuccessHandler())).failureHandler((AuthenticationFailureHandler)this.oidcAuthenticationFailureHandler())).authorizationEndpoint(authorizationEndpointConfig -> {
                OAuth2LoginConfigurer.AuthorizationEndpointConfig authorizationEndpointConfig2 = authorizationEndpointConfig.baseUri(AUTHORIZATION_ENDPOINT).authorizationRequestRepository(this.authorizationRequestRepository());
            }).redirectionEndpoint(redirectionEndpointConfig -> {
                OAuth2LoginConfigurer.RedirectionEndpointConfig redirectionEndpointConfig2 = redirectionEndpointConfig.baseUri(REDIRECTION_ENDPOINT);
            }).userInfoEndpoint(userInfoEndpointConfig -> {
                OAuth2LoginConfigurer.UserInfoEndpointConfig userInfoEndpointConfig2 = userInfoEndpointConfig.userAuthoritiesMapper((GrantedAuthoritiesMapper)this.squashOidcGrantedAuthoritiesMapper());
            });
        });
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public AuthorizationRequestRepository<OAuth2AuthorizationRequest> authorizationRequestRepository() {
        return new HttpSessionOAuth2AuthorizationRequestRepository();
    }

    @Bean
    public SavedRequestAwareAuthenticationSuccessHandler oidcAuthenticationSuccessHandler() {
        SavedRequestAwareAuthenticationSuccessHandler successRedirectHandler = new SavedRequestAwareAuthenticationSuccessHandler();
        successRedirectHandler.setDefaultTargetUrl("/");
        return successRedirectHandler;
    }

    @Bean
    public SimpleUrlAuthenticationFailureHandler oidcAuthenticationFailureHandler() {
        return new SimpleUrlAuthenticationFailureHandler("/auth/oidc/authentication-failure");
    }

    @Bean
    public SquashOidcGrantedAuthoritiesMapper squashOidcGrantedAuthoritiesMapper() {
        return new SquashOidcGrantedAuthoritiesMapper();
    }
}

