/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.internal.providers.entity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.activation.DataSource;
import plugin.rtc.javax.ws.rs.Consumes;
import plugin.rtc.javax.ws.rs.Produces;
import plugin.rtc.javax.ws.rs.WebApplicationException;
import plugin.rtc.javax.ws.rs.core.MediaType;
import plugin.rtc.javax.ws.rs.core.MultivaluedMap;
import plugin.rtc.javax.ws.rs.ext.MessageBodyReader;
import plugin.rtc.javax.ws.rs.ext.MessageBodyWriter;
import plugin.rtc.javax.ws.rs.ext.Provider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"*/*"})
@Consumes(value={"*/*"})
public class DataSourceProvider
implements MessageBodyReader<DataSource>,
MessageBodyWriter<DataSource> {
    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.isAssignableFrom(DataSource.class);
    }

    @Override
    public DataSource readFrom(Class<DataSource> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        return new ByteArrayDataSource(entityStream, mediaType == null ? null : mediaType.toString());
    }

    @Override
    public long getSize(DataSource t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return DataSource.class.isAssignableFrom(type);
    }

    @Override
    public void writeTo(DataSource t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        int read;
        InputStream inputStream = t.getInputStream();
        byte[] data = new byte[2048];
        while ((read = inputStream.read(data)) != -1) {
            entityStream.write(data, 0, read);
        }
        entityStream.flush();
    }

    public static class ByteArrayDataSource
    implements DataSource {
        private final String contentType;
        private final byte[] buffer;
        private final int length;

        public ByteArrayDataSource(InputStream is, String contentType) throws IOException {
            int len;
            DataStoreByteArrayOutputStream os = new DataStoreByteArrayOutputStream();
            byte[] buf = new byte[8192];
            while ((len = is.read(buf)) > 0) {
                os.write(buf, 0, len);
            }
            this.buffer = os.getBuf();
            this.length = os.getCount();
            this.contentType = contentType;
        }

        public String getContentType() {
            return this.contentType;
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.buffer, 0, this.length);
        }

        public String getName() {
            return null;
        }

        public OutputStream getOutputStream() {
            throw new UnsupportedOperationException();
        }

        static class DataStoreByteArrayOutputStream
        extends ByteArrayOutputStream {
            DataStoreByteArrayOutputStream() {
            }

            public byte[] getBuf() {
                return this.buf;
            }

            public int getCount() {
                return this.count;
            }
        }
    }
}

