/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.http.protocol;

import java.io.IOException;
import plugin.rtc.org.apache.http.HttpEntityEnclosingRequest;
import plugin.rtc.org.apache.http.HttpException;
import plugin.rtc.org.apache.http.HttpRequest;
import plugin.rtc.org.apache.http.HttpRequestInterceptor;
import plugin.rtc.org.apache.http.annotation.Contract;
import plugin.rtc.org.apache.http.annotation.ThreadingBehavior;
import plugin.rtc.org.apache.http.protocol.HttpContext;
import plugin.rtc.org.apache.http.protocol.HttpDateGenerator;
import plugin.rtc.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

