/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.impl;

import java.util.ArrayList;
import java.util.List;
import plugin.rtc.com.hp.hpl.jena.graph.Graph;
import plugin.rtc.com.hp.hpl.jena.graph.Node;
import plugin.rtc.com.hp.hpl.jena.graph.Triple;
import plugin.rtc.com.hp.hpl.jena.reasoner.Finder;
import plugin.rtc.com.hp.hpl.jena.reasoner.TriplePattern;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.Rule;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.RulePreprocessHook;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.Util;
import plugin.rtc.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import plugin.rtc.com.hp.hpl.jena.vocabulary.OWL;
import plugin.rtc.com.hp.hpl.jena.vocabulary.RDF;
import plugin.rtc.com.hp.hpl.jena.vocabulary.RDFS;

public class OWLExptRuleTranslationHook
implements RulePreprocessHook {
    @Override
    public void run(FBRuleInfGraph infGraph, Finder dataFind, Graph inserts) {
        ExtendedIterator<Triple> it = dataFind.find(new TriplePattern(null, OWL.intersectionOf.asNode(), null));
        while (it.hasNext()) {
            Triple decl = (Triple)it.next();
            Node className = decl.getSubject();
            ArrayList<Node> elements = new ArrayList<Node>();
            OWLExptRuleTranslationHook.translateIntersectionList(decl.getObject(), dataFind, elements);
            ArrayList<ClauseEntry> recognitionBody = new ArrayList<ClauseEntry>();
            Node_RuleVariable var = new Node_RuleVariable("?x", 0);
            for (Node description : elements) {
                Rule ir = new Rule("intersectionImplication", new ClauseEntry[]{new TriplePattern(className, RDFS.subClassOf.asNode(), description)}, new ClauseEntry[0]);
                ir.setBackward(false);
                infGraph.addRuleDuringPrepare(ir);
                recognitionBody.add(new TriplePattern(var, RDF.type.asNode(), description));
            }
            ArrayList<ClauseEntry> recognitionHead = new ArrayList<ClauseEntry>(1);
            recognitionHead.add(new TriplePattern(var, RDF.type.asNode(), className));
            Rule rr = new Rule("intersectionRecognition", recognitionHead, recognitionBody);
            rr.setBackward(true);
            infGraph.addRuleDuringPrepare(rr);
        }
    }

    protected static void translateIntersectionList(Node node, Finder dataFind, List<Node> elements) {
        if (node.equals(RDF.nil.asNode())) {
            return;
        }
        Node description = Util.getPropValue(node, RDF.first.asNode(), dataFind);
        elements.add(description);
        Node next = Util.getPropValue(node, RDF.rest.asNode(), dataFind);
        OWLExptRuleTranslationHook.translateIntersectionList(next, dataFind, elements);
    }

    @Override
    public boolean needsRerun(FBRuleInfGraph infGraph, Triple t) {
        return t.getPredicate().equals(OWL.intersectionOf.asNode());
    }
}

