/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.rtc;

import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.squashtest.csp.core.bugtracker.core.NamespacedBugtrackerMessageSource;
import org.squashtest.tm.api.config.SquashPathProperties;
import org.squashtest.tm.plugin.bugtracker.rtc.licensevalidator.LicenseValidator;
import org.squashtest.tm.plugin.bugtracker.rtc.licensevalidator.service.ValidationService;
import org.squashtest.tm.plugin.bugtracker.rtc.licensevalidator.service.impl.ValidationServiceImpl;

@Configuration
@ComponentScan(basePackages={"org.squashtest.tm.plugin.bugtracker.rtc"})
public class RtcConnectorConfig {
    @Inject
    private SquashPathProperties squashPathProperties;

    @Bean
    public MessageSource rtcConnectorMessageSource() {
        ReloadableResourceBundleMessageSource bean = new ReloadableResourceBundleMessageSource();
        bean.setCacheSeconds(60);
        bean.setBasenames(new String[]{"classpath:/org/squashtest/tm/plugin/bugtracker/rtc/messages", String.valueOf(this.squashPathProperties.getLanguagesPath()) + "/plugin.bugtracker.rtc/messages"});
        return new NamespacedBugtrackerMessageSource((MessageSource)bean, "bugtracker.rtc.");
    }

    @Bean(name={"org.squashtest.tm.plugin.bugtracker.rtc.ValidationService"})
    public ValidationService validationService() {
        return new ValidationServiceImpl();
    }

    @Bean(name={"org.squashtest.tm.plugin.bugtracker.rtc.LicenseValidator"})
    public LicenseValidator licenseValidator(@Named(value="org.squashtest.tm.plugin.bugtracker.rtc.ValidationService") @Named(value="org.squashtest.tm.plugin.bugtracker.rtc.ValidationService") ValidationService service) {
        return new LicenseValidator(service);
    }
}

