/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.rtc;

import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsException;
import plugin.rtc.org.eclipse.lyo.client.exception.JazzAuthErrorException;

@Component
public class ExceptionHandler {
    @Inject
    @Named(value="rtcConnectorMessageSource")
    private MessageSource messageSource;
    private static final String AUTH_ERROR = "exception.squash.unreachable";
    private static final String WRONG_CREDENTIALS = "exception.squash.accessdenied";

    private Locale getLocale() {
        return LocaleContextHolder.getLocale();
    }

    public BugTrackerNoCredentialsException authenticationException(Exception exception) {
        Object[] args = this.toMsgArgs(exception);
        String translation = this.messageSource.getMessage(WRONG_CREDENTIALS, args, this.getLocale());
        return new BugTrackerNoCredentialsException(translation, exception.getCause());
    }

    public BugTrackerNoCredentialsException authErrorException(JazzAuthErrorException exception) {
        String msg = this.getMessageOrBlank(exception);
        int code = exception.getStatus();
        Object[] args = new Object[]{code, msg};
        String translation = this.messageSource.getMessage(AUTH_ERROR, args, this.getLocale());
        return new BugTrackerNoCredentialsException(translation, (Throwable)exception);
    }

    private Object[] toMsgArgs(Exception exception) {
        Object[] objectArray;
        String expression = exception.getMessage();
        if (expression != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = expression;
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    private String getMessageOrBlank(Exception ex) {
        String msg = ex.getMessage();
        return msg != null ? msg : "";
    }
}

