/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.jirarest.internal;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import jirarest.com.atlassian.httpclient.api.Request;
import jirarest.com.atlassian.jira.rest.client.api.AuthenticationHandler;
import jirarest.com.atlassian.jira.rest.client.api.RestClientException;
import jirarest.com.atlassian.jira.rest.client.api.domain.BasicIssue;
import jirarest.com.atlassian.jira.rest.client.api.domain.BasicUser;
import jirarest.com.atlassian.jira.rest.client.api.domain.CimProject;
import jirarest.com.atlassian.jira.rest.client.api.domain.Issue;
import jirarest.com.atlassian.jira.rest.client.api.domain.Priority;
import jirarest.com.atlassian.jira.rest.client.api.domain.input.AttachmentInput;
import jirarest.com.atlassian.jira.rest.client.api.domain.input.CannotTransformValueException;
import jirarest.com.atlassian.jira.rest.client.api.domain.input.IssueInput;
import jirarest.com.atlassian.jira.rest.client.api.domain.input.LinkIssuesInput;
import jirarest.com.sun.jersey.api.client.UniformInterfaceException;
import jirarest.com.sun.ws.rs.core.UriBuilder;
import jirarest.org.apache.http.util.EncodingUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.core.BugTrackerLocalException;
import org.squashtest.csp.core.bugtracker.core.UnsupportedAuthenticationModeException;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.BasicAuthenticationCredentials;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.OAuth2Credentials;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.JiraBugTrackerInterfaceDescriptor;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.JiraClient;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.JiraVersion;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.MovedIssue;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.StubIssue;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.exceptions.ExceptionHandler;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.exceptions.JiraProjectNotFound;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.extension.CustomJiraClientFactory;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.extension.ExtendedJiraRestClient;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.json.BasicEntity;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.json.ServerInfo;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.json.SimpleSprint;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.operations.CreateIssue;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.operations.FindIssueURL;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.operations.ForwardAttachments;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.operations.GetIssue;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.operations.GetIssues;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.operations.GetPriorities;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.operations.GetProjectForCreateByKeyOrId;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.operations.GetProjectKeyByName;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.operations.GetReporter;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.operations.GetServerInfo;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.operations.JR6SearchEpics;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.operations.JR7SearchEpics;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.operations.JiraRestClientOperation;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.operations.LinkIssue;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.operations.SearchAssignableUsers;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.operations.SearchPossibleReporter;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.operations.SearchSprints;

@Component
@Scope(value="prototype")
public class JiraClientImpl
implements JiraClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraClientImpl.class);
    private static final String LOG_HEADER = "JIRA REST client : ";
    private static final String AN_ERROR_OCCURED = "an error occured during operation : ";
    private static boolean disabledExtension = false;
    private static final Map<String, JiraVersion> VERSION_CACHE = new ConcurrentHashMap<String, JiraVersion>();
    @Inject
    private ExceptionHandler exceptionHandler;
    @Inject
    @Named(value="jiraRestConnectorMessageSource")
    private MessageSource messageSource;
    @Inject
    @Named(value="jiraBugTrackerInterfaceDescriptor")
    private BugTrackerInterfaceDescriptor descriptor;
    private URI greenHopperURI;
    private String baseUrl;
    private ExtendedJiraRestClient client;

    private Locale getLocale() {
        return ((JiraBugTrackerInterfaceDescriptor)this.descriptor).getLocale();
    }

    @Override
    public void init(BugTracker bugTracker, Credentials credentials) {
        URI uri;
        LOGGER.debug("creating the jira client");
        this.baseUrl = bugTracker.getUrl();
        try {
            uri = new URL(bugTracker.getUrl()).toURI();
        }
        catch (MalformedURLException | URISyntaxException exception) {
            throw this.logAndThrowLocalException("JIRA REST client : url " + bugTracker.getUrl() + " is invalid", exception);
        }
        AuthenticationHandler authHandler = JiraClientImpl.createAuthHandler(credentials);
        this.client = new CustomJiraClientFactory().create(uri, authHandler);
        String btUrl = bugTracker.getUrl().replaceAll("\\/*$", "");
        this.greenHopperURI = UriBuilder.fromUri(String.valueOf(btUrl) + "/rest/greenhopper/1.0").build(new Object[0]);
        this.initJiraVersion(bugTracker);
    }

    @Override
    public ServerInfo findServerInfo() {
        LOGGER.debug("fetching remote JIRA server info");
        GetServerInfo operation = new GetServerInfo(this.client);
        return this.doInCatchBlock(operation);
    }

    @Override
    public Iterable<Priority> getAllPriorities() {
        LOGGER.debug("fetching priorities");
        GetPriorities operation = new GetPriorities(this.client);
        return this.doInCatchBlock(operation);
    }

    @Override
    public String findProjectKeyByName(String projectName) {
        LOGGER.debug("fetching project named '{}'", (Object)projectName);
        GetProjectKeyByName operation = new GetProjectKeyByName(this.client, projectName);
        return this.doInCatchBlock(operation);
    }

    @Override
    public String getReporter() {
        LOGGER.debug("fetching reporter username");
        GetReporter operation = new GetReporter(this.client);
        return this.doInCatchBlock(operation);
    }

    @Override
    public CimProject findProjectForCreateById(Long projectId) {
        LOGGER.debug("fetching issue creation metadata (project id : '{}')", (Object)projectId);
        GetProjectForCreateByKeyOrId operation = new GetProjectForCreateByKeyOrId(this.client, Long.toString(projectId));
        return this.doInCatchBlock(operation);
    }

    @Override
    public CimProject findProjectForCreateByKey(String projectKey) {
        LOGGER.debug("fetching issue creation metadata (project key : '{}')", (Object)projectKey);
        GetProjectForCreateByKeyOrId operation = new GetProjectForCreateByKeyOrId(this.client, projectKey);
        return this.doInCatchBlock(operation);
    }

    @Override
    public Issue findIssue(String issueKey) {
        LOGGER.debug("fetching issue '{}'", (Object)issueKey);
        GetIssue operation = new GetIssue(this.client, issueKey);
        return this.doInCatchBlock(operation);
    }

    @Override
    public Iterable<Issue> findIssues(List<String> issueKeys) {
        LOGGER.debug("fetching issues : {}", issueKeys);
        GetIssues operation = new GetIssues(this.client, issueKeys);
        Object issues = new ArrayList();
        try {
            issues = operation.doIt();
        }
        catch (RestClientException ex) {
            LOGGER.trace("JIRA REST client : an error occured during operation : " + operation.toString(), (Throwable)ex);
            this.findDeletedIssues(issueKeys, (Iterable<? extends Issue>)issues);
        }
        return this.findMovedIssues((Iterable<Issue>)issues, issueKeys);
    }

    private void findDeletedIssues(List<String> issueKeys, Iterable<? extends Issue> issues) {
        LOGGER.debug("looking for deleted issues among {}", issueKeys);
        for (String issueKey : issueKeys) {
            ArrayList<String> issueList = new ArrayList<String>();
            issueList.add(issueKey);
            GetIssues getIssue = new GetIssues(this.client, issueList);
            try {
                ((ArrayList)issues).addAll(getIssue.doIt());
                LOGGER.trace("\tissue : {} - alive", (Object)issueKey);
            }
            catch (RestClientException restClientException) {
                LOGGER.trace("\tissue : {} - deleted", (Object)issueKey);
                ((ArrayList)issues).add(new StubIssue(issueKey, this.messageSource, this.getLocale()));
            }
        }
    }

    private List<Issue> findMovedIssues(Iterable<Issue> issues, List<String> issueKeys) {
        LOGGER.debug("looking for moved issues among {}", issueKeys);
        ArrayList<Issue> issuesWithCorrectKey = new ArrayList<Issue>();
        ArrayList<String> btIssueKeys = new ArrayList<String>();
        for (Issue issue : issues) {
            btIssueKeys.add(issue.getKey());
        }
        block1: for (String issueKey : issueKeys) {
            if (btIssueKeys.contains(issueKey)) {
                for (Issue issue : issues) {
                    if (!issue.getKey().equals(issueKey)) continue;
                    issuesWithCorrectKey.add(issue);
                    LOGGER.trace("\tissue : {} - still in place", (Object)issueKey);
                    continue block1;
                }
                continue;
            }
            LOGGER.trace("\tissue : {} - probably moved, investigating further", (Object)issueKey);
            issuesWithCorrectKey.add(this.findMovedIssue(issueKey));
        }
        return issuesWithCorrectKey;
    }

    public MovedIssue findMovedIssue(String issueKey) {
        LOGGER.debug("\tlooking for (presumably) moved issue '{}'", (Object)issueKey);
        GetIssue operation = new GetIssue(this.client, issueKey);
        return new MovedIssue(operation.doItWithChangelog(), issueKey);
    }

    @Override
    public BasicIssue createIssue(IssueInput issueInput) {
        LOGGER.debug("creating new issue");
        CreateIssue operation = new CreateIssue(this.client, issueInput);
        return this.doInCatchBlock(operation);
    }

    @Override
    public URL findIssueURL(String issueKey) {
        LOGGER.debug("finding URL for issue {}", (Object)issueKey);
        FindIssueURL operation = new FindIssueURL(this.client, issueKey);
        return this.doInCatchBlock(operation);
    }

    @Override
    public void forwardAttachments(String issueKey, Collection<AttachmentInput> attachments) {
        LOGGER.debug("forwarding attachments for issue {}", (Object)issueKey);
        ForwardAttachments operation = new ForwardAttachments(this.client, issueKey, attachments);
        this.doInCatchBlock(operation);
    }

    @Override
    public Iterable<BasicUser> searchAssignableUsers(String projectKey, String namePrefix) {
        LOGGER.debug("searching assignable users in project '{}' having names starting with '{}'", (Object)projectKey, (Object)namePrefix);
        if (!disabledExtension) {
            LOGGER.trace("\textension client enabled, proceeding");
            SearchAssignableUsers operation = new SearchAssignableUsers(this.client, projectKey, namePrefix);
            return this.doInCatchBlock(operation);
        }
        LOGGER.trace("\textension client disabled, cannot search the assignable users. Returning empty list.");
        return Collections.emptyList();
    }

    @Override
    public Iterable<BasicUser> searchPossisbleReporter(String namePrefix) {
        LOGGER.debug("searching reporters having name starting with '{}'", (Object)namePrefix);
        if (!disabledExtension) {
            LOGGER.trace("\textension client enabled, proceeding");
            SearchPossibleReporter operation = new SearchPossibleReporter(this.client, namePrefix);
            return this.doInCatchBlock(operation);
        }
        LOGGER.trace("\textension client disabled, cannot search the reporters. Returning empty list.");
        return Collections.emptyList();
    }

    @Override
    public Iterable<SimpleSprint> searchAvailableSprints() {
        LOGGER.debug("searching available sprints");
        if (!disabledExtension) {
            LOGGER.trace("\textension client enabled, proceeding");
            SearchSprints operation = new SearchSprints(this.client, this.greenHopperURI);
            return this.doInCatchBlock(operation);
        }
        LOGGER.trace("\textension client disabled, cannot search the sprints. Returning empty list.");
        return Collections.emptyList();
    }

    @Override
    public Iterable<BasicEntity> searchAvailableEpics(String projectKey, String searchString) {
        LOGGER.debug("searching available epics for project '{}' with name like '{}'", (Object)projectKey, (Object)searchString);
        if (!disabledExtension) {
            LOGGER.trace("\textension client enabled, proceeding");
            JiraVersion version = this.getJiraVersion();
            JiraRestClientOperation operation = switch (version) {
                case JiraVersion.JIRA_5, JiraVersion.JIRA_6 -> new JR6SearchEpics(this.client, this.greenHopperURI, projectKey, searchString);
                case JiraVersion.JIRA_7 -> new JR7SearchEpics(this.client, this.greenHopperURI, projectKey, searchString);
                default -> new JR7SearchEpics(this.client, this.greenHopperURI, projectKey, searchString);
            };
            return this.doInCatchBlock(operation);
        }
        LOGGER.trace("\textension client disabled, cannot search the epics. Returning empty list.");
        return Collections.emptyList();
    }

    @Override
    public void linkIssue(LinkIssuesInput input) {
        LOGGER.debug("Creation of link {} from issue {} to issue {}", new Object[]{input.getLinkType(), input.getFromIssueKey(), input.getToIssueKey()});
        LinkIssue operation = new LinkIssue(this.client, input);
        this.doInCatchBlock(operation);
    }

    private <ANY> ANY doInCatchBlock(JiraRestClientOperation<? extends ANY> operation) {
        try {
            return operation.doIt();
        }
        catch (JiraProjectNotFound ex) {
            LOGGER.error("JIRA REST client : project identified by " + ex.getMessage() + " was not found", (Throwable)ex);
            throw this.exceptionHandler.projectNotFound(ex);
        }
        catch (UniformInterfaceException ex) {
            LOGGER.error("JIRA REST client : an error occured during operation : " + operation.getName(), (Throwable)ex);
            throw this.exceptionHandler.handleUniformException(ex, ex.getMessage());
        }
        catch (RestClientException ex) {
            LOGGER.error("JIRA REST client : an error occured during operation : " + operation.getName(), (Throwable)ex);
            throw this.exceptionHandler.handleRestException(ex);
        }
        catch (NumberFormatException ex) {
            LOGGER.error("JIRA REST client : an error occured during operation : " + operation.getName(), (Throwable)ex);
            throw this.exceptionHandler.genericError(ex);
        }
        catch (CannotTransformValueException ex) {
            LOGGER.error("JIRA REST client : an error occured during operation : " + operation.getName(), (Throwable)ex);
            throw this.exceptionHandler.genericError(ex);
        }
        catch (Exception ex) {
            LOGGER.error("JIRA REST client : an error occured during operation : " + operation.getName(), (Throwable)ex);
            throw this.exceptionHandler.genericError(ex);
        }
    }

    private void initJiraVersion(BugTracker bt) {
        String btUrl = bt.getUrl();
        if (!VERSION_CACHE.containsKey(btUrl)) {
            ServerInfo infos = this.findServerInfo();
            JiraVersion version = infos.isCloud() ? JiraVersion.getLastKnownVersion() : JiraVersion.byMajorVersion(infos.getMajorVersion());
            VERSION_CACHE.put(btUrl, version);
            LOGGER.debug("detected version for bugtracker '{}', JIRA version is : '{}'", (Object)bt.getName(), (Object)version);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.client != null) {
            LOGGER.debug("closing client");
            this.client.close();
        } else {
            LOGGER.debug("client was null, nothing to close");
        }
    }

    private JiraVersion getJiraVersion() {
        JiraVersion version = VERSION_CACHE.get(this.baseUrl);
        if (version == null) {
            version = JiraVersion.getLastKnownVersion();
        }
        return version;
    }

    private BugTrackerLocalException logAndThrowLocalException(String message, Exception cause) {
        LOGGER.error(message);
        return new BugTrackerLocalException(message, (Throwable)cause);
    }

    private static AuthenticationHandler createAuthHandler(Credentials credentials) {
        return switch (credentials.getImplementedProtocol()) {
            case AuthenticationProtocol.BASIC_AUTH -> {
                BasicAuthenticationCredentials basicCreds = (BasicAuthenticationCredentials)credentials;
                yield new Latin1BasicAuthHandler(basicCreds.getUsername(), new String(basicCreds.getPassword()));
            }
            case AuthenticationProtocol.OAUTH_2 -> {
                OAuth2Credentials oauth2Creds = (OAuth2Credentials)credentials;
                yield new OAuth2Handler(oauth2Creds);
            }
            default -> throw new UnsupportedAuthenticationModeException(credentials.getImplementedProtocol().toString());
        };
    }

    private static final class Latin1BasicAuthHandler
    implements AuthenticationHandler {
        private String username;
        private String password;

        Latin1BasicAuthHandler(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public void configure(Request.Builder builder) {
            byte[] encoded = this.encode(this.username, this.password);
            builder.setHeader("Authorization", "Basic " + new String(encoded));
        }

        private byte[] encode(String username, String password) {
            String toEncode = String.valueOf(username) + ":" + password;
            return Base64.encodeBase64((byte[])EncodingUtils.getBytes(toEncode, StandardCharsets.ISO_8859_1.name()));
        }
    }

    private static final class OAuth2Handler
    implements AuthenticationHandler {
        private final OAuth2Credentials credentials;
        private static final String HTTP_AUTHORIZATION = "Authorization";

        public OAuth2Handler(OAuth2Credentials credentials) {
            this.credentials = credentials;
        }

        @Override
        public void configure(Request.Builder builder) {
            builder.build();
            String tokenType = StringUtils.capitalize((String)this.credentials.getTokenType());
            builder.setHeader(HTTP_AUTHORIZATION, String.format("%s %s", tokenType, this.credentials.getAccessToken()));
        }
    }
}

