/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.campaignassessment;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.View;
import org.squashtest.tm.api.report.DocxTemplaterReport;
import org.squashtest.tm.api.report.Report;
import org.squashtest.tm.api.report.ReportPlugin;
import org.squashtest.tm.api.report.ReportView;
import org.squashtest.tm.api.report.StandardReportCategory;
import org.squashtest.tm.api.report.StandardReportType;
import org.squashtest.tm.api.report.docxtemplater.DocxTemplaterView;
import org.squashtest.tm.api.report.form.CheckboxInput;
import org.squashtest.tm.api.report.form.Form;
import org.squashtest.tm.api.report.form.Input;
import org.squashtest.tm.api.report.form.NodeType;
import org.squashtest.tm.api.report.form.OptionInput;
import org.squashtest.tm.api.report.form.TemplateDropdownList;
import org.squashtest.tm.api.report.form.TreePicker;
import org.squashtest.tm.api.report.query.ReportQuery;
import org.squashtest.tm.api.report.spring.view.docxtemplater.DocxTemplaterDocxView;
import org.squashtest.tm.plugin.report.campaignassessment.licensevalidator.LicenseValidator;
import org.squashtest.tm.plugin.report.campaignassessment.licensevalidator.service.ValidationService;
import org.squashtest.tm.plugin.report.campaignassessment.licensevalidator.service.impl.ValidationServiceImpl;
import org.squashtest.tm.plugin.report.campaignassessment.query.CampaignTreeQuery;
import org.squashtest.tm.plugin.report.campaignassessment.query.IterationTreeQuery;

@Configuration
public class ReportBookCampaignConfiguration {
    private static final String CAMPAIGN_TEMPLATE_FOLDER = "report.campaigns";
    private static final String ITERATION_TEMPLATE_FOLDER = "report.iterations";
    private static final String CAMPAIGN_REPORT_DEFAULT_PATH = "classpath:template/report.campaigns.template.docx";
    private static final String ITERATION_REPORT_DEFAULT_PATH = "classpath:template/report.iterations.template.docx";
    public static final String TEMPLATE_FILE_NAME = "templateFileName";
    public static final String DEFAULT_TEMPLATE_VALUE = "defaultTemplate";
    @Value(value="${squash.report-custom-template.folder-path}")
    private String reportCustomTemplateFolderPath;
    @Inject
    MessageSource messageSource;

    @Bean
    public ReportPlugin reportPlugin(DocxTemplaterReport campaignDocxTemplaterReport, DocxTemplaterReport iterationDocxTemplaterReport) {
        Report[] reports = new Report[]{campaignDocxTemplaterReport, iterationDocxTemplaterReport};
        ReportPlugin reportPlugin = new ReportPlugin();
        reportPlugin.setReports(reports);
        return reportPlugin;
    }

    @Bean
    public DocxTemplaterReport campaignDocxTemplaterReport(DocxTemplaterView campaignDocxTemplaterView, Form campaignForm) {
        DocxTemplaterReport docxTemplaterReport = new DocxTemplaterReport();
        docxTemplaterReport.setCategory(StandardReportCategory.EXECUTION_PHASE);
        docxTemplaterReport.setType(StandardReportType.GENERIC);
        docxTemplaterReport.setLabelKey("report.campaignassessment.report.label");
        docxTemplaterReport.setDescriptionKey("report.campaignassessment.report.description");
        docxTemplaterReport.setCustomTemplateFolderPath(this.generateCustomTemplateFolderPath(CAMPAIGN_TEMPLATE_FOLDER));
        docxTemplaterReport.setDefaultTemplateFilePath(CAMPAIGN_REPORT_DEFAULT_PATH);
        ReportView[] views = new ReportView[]{campaignDocxTemplaterView};
        docxTemplaterReport.setViews(views);
        docxTemplaterReport.setForm(campaignForm.getInputs().toArray(new Input[campaignForm.getInputs().size()]));
        return docxTemplaterReport;
    }

    @Bean
    public DocxTemplaterReport iterationDocxTemplaterReport(DocxTemplaterView iterationDocxTemplaterView, Form iterationForm) {
        DocxTemplaterReport docxTemplaterReport = new DocxTemplaterReport();
        docxTemplaterReport.setCategory(StandardReportCategory.EXECUTION_PHASE);
        docxTemplaterReport.setType(StandardReportType.GENERIC);
        docxTemplaterReport.setLabelKey("report.iteration.report.label");
        docxTemplaterReport.setDescriptionKey("report.iteration.report.description");
        docxTemplaterReport.setCustomTemplateFolderPath(this.generateCustomTemplateFolderPath(ITERATION_TEMPLATE_FOLDER));
        docxTemplaterReport.setDefaultTemplateFilePath(ITERATION_REPORT_DEFAULT_PATH);
        ReportView[] views = new ReportView[]{iterationDocxTemplaterView};
        docxTemplaterReport.setViews(views);
        docxTemplaterReport.setForm(iterationForm.getInputs().toArray(new Input[iterationForm.getInputs().size()]));
        return docxTemplaterReport;
    }

    @Bean
    public Form campaignForm(@Named(value="campaignTemplateDropdownList") @Named(value="campaignTemplateDropdownList") TemplateDropdownList campaignTemplateDropdownList, @Named(value="campaignTreePricker") @Named(value="campaignTreePricker") TreePicker campaignTreePicker, @Named(value="includeAnnexCheckbox") @Named(value="includeAnnexCheckbox") CheckboxInput includeAnnexCheckbox, @Named(value="includeIterationDetailCheckbox") @Named(value="includeIterationDetailCheckbox") CheckboxInput includeIterationDetailCheckbox, @Named(value="includeAnomaliesDetailCheckbox") @Named(value="includeAnomaliesDetailCheckbox") CheckboxInput includeAnomaliesDetailCheckbox) {
        Form form = new Form();
        ArrayList<Object> inputs = new ArrayList<Object>();
        inputs.add(campaignTemplateDropdownList);
        inputs.add(campaignTreePicker);
        inputs.add(includeAnnexCheckbox);
        inputs.add(includeIterationDetailCheckbox);
        inputs.add(includeAnomaliesDetailCheckbox);
        form.setInputs(inputs);
        return form;
    }

    @Bean
    public Form iterationForm(@Named(value="iterationTemplateDropdownList") @Named(value="iterationTemplateDropdownList") TemplateDropdownList iterationTemplateDropdownList, @Named(value="iterationTreePricker") @Named(value="iterationTreePricker") TreePicker iterationTreePricker, @Named(value="includeAnnexCheckbox") @Named(value="includeAnnexCheckbox") CheckboxInput includeAnnexCheckbox, @Named(value="includeTestSuiteDetailCheckbox") @Named(value="includeTestSuiteDetailCheckbox") CheckboxInput includeTestSuiteDetailCheckbox, @Named(value="includeAnomaliesDetailCheckbox") @Named(value="includeAnomaliesDetailCheckbox") CheckboxInput includeAnomaliesDetailCheckbox) {
        Form form = new Form();
        ArrayList<Object> inputs = new ArrayList<Object>();
        inputs.add(iterationTemplateDropdownList);
        inputs.add(iterationTreePricker);
        inputs.add(includeAnnexCheckbox);
        inputs.add(includeTestSuiteDetailCheckbox);
        inputs.add(includeAnomaliesDetailCheckbox);
        form.setInputs(inputs);
        return form;
    }

    @Bean(name={"campaignTemplateDropdownList"})
    public TemplateDropdownList campaignDropdownList() {
        TemplateDropdownList templateDropdownList = new TemplateDropdownList();
        templateDropdownList.setName(TEMPLATE_FILE_NAME);
        templateDropdownList.setLabelKey("report.campaignexecution.template.label");
        templateDropdownList.setFolderPath(this.generateCustomTemplateFolderPath(CAMPAIGN_TEMPLATE_FOLDER));
        templateDropdownList.setFileDoesNotExistMessageKey("report.campaignassessment.file-does-not-exist.message");
        templateDropdownList.setOptions(this.generateTemplateDefaultOption());
        return templateDropdownList;
    }

    @Bean(name={"iterationTemplateDropdownList"})
    public TemplateDropdownList iterationTemplateDropdownList() {
        TemplateDropdownList templateDropdownList = new TemplateDropdownList();
        templateDropdownList.setName(TEMPLATE_FILE_NAME);
        templateDropdownList.setLabelKey("report.campaignexecution.template.label");
        templateDropdownList.setFolderPath(this.generateCustomTemplateFolderPath(ITERATION_TEMPLATE_FOLDER));
        templateDropdownList.setFileDoesNotExistMessageKey("report.iteration.file-does-not-exist.message");
        templateDropdownList.setOptions(this.generateTemplateDefaultOption());
        return templateDropdownList;
    }

    @Bean(name={"campaignTreePricker"})
    public TreePicker campaignTreePricker() {
        TreePicker treePicker = new TreePicker();
        treePicker.setPickedNodeType(NodeType.CAMPAIGN);
        treePicker.setName("campaignId");
        treePicker.setLabelKey("report.campaignassessment.picker.label");
        treePicker.setNodeSelectionLimit(1);
        treePicker.setRequired(true);
        treePicker.setStrict(true);
        return treePicker;
    }

    @Bean(name={"iterationTreePricker"})
    public TreePicker iterationTreePricker() {
        TreePicker treePicker = new TreePicker();
        treePicker.setPickedNodeType(NodeType.CAMPAIGN);
        treePicker.setName("iterationId");
        treePicker.setLabelKey("report.iteration.picker.label");
        treePicker.setNodeSelectionLimit(1);
        treePicker.setStrict(true);
        treePicker.setJsTreeNodeType("iteration");
        treePicker.setRequired(true);
        return treePicker;
    }

    @Bean(name={"includeAnnexCheckbox"})
    public CheckboxInput includeAnnexCheckbox() {
        CheckboxInput includeAnnexCheckbox = new CheckboxInput();
        includeAnnexCheckbox.setName("includeAnnex");
        includeAnnexCheckbox.setLabelKey("report.iteration.include.annex.label");
        return includeAnnexCheckbox;
    }

    @Bean(name={"includeIterationDetailCheckbox"})
    public CheckboxInput includeIterationDetailCheckbox() {
        CheckboxInput includeIterationDetailCheckbox = new CheckboxInput();
        includeIterationDetailCheckbox.setName("includeIterationDetails");
        includeIterationDetailCheckbox.setLabelKey("report.iteration.include.iteration.detail.label");
        return includeIterationDetailCheckbox;
    }

    @Bean(name={"includeAnomaliesDetailCheckbox"})
    public CheckboxInput includeAnomaliesDetailCheckbox() {
        CheckboxInput includeAnomaliesDetailCheckbox = new CheckboxInput();
        includeAnomaliesDetailCheckbox.setName("includeAnomaliesDetails");
        includeAnomaliesDetailCheckbox.setLabelKey("report.iteration.include.anomalies.detail.label");
        includeAnomaliesDetailCheckbox.setHelpI18nKey("report.campaignassessment.include.bugtracker.connection.label");
        return includeAnomaliesDetailCheckbox;
    }

    @Bean(name={"includeTestSuiteDetailCheckbox"})
    public CheckboxInput includeTestSuiteDetailCheckbox() {
        CheckboxInput includeIterationDetailCheckbox = new CheckboxInput();
        includeIterationDetailCheckbox.setName("includeTestSuiteDetail");
        includeIterationDetailCheckbox.setLabelKey("report.iteration.include.suite.detail.label");
        return includeIterationDetailCheckbox;
    }

    @Bean
    public DocxTemplaterView campaignDocxTemplaterView(DocxTemplaterDocxView campaignDocxTemplaterDocxView, ReportQuery campaignReportQuery) {
        DocxTemplaterView docxTemplaterView = new DocxTemplaterView();
        docxTemplaterView.setQuery(campaignReportQuery);
        docxTemplaterView.setSpringView((View)campaignDocxTemplaterDocxView);
        return docxTemplaterView;
    }

    @Bean
    public DocxTemplaterView iterationDocxTemplaterView(DocxTemplaterDocxView iterationDocxTemplaterDocxView, ReportQuery iterationReportQuery) {
        DocxTemplaterView docxTemplaterView = new DocxTemplaterView();
        docxTemplaterView.setQuery(iterationReportQuery);
        docxTemplaterView.setSpringView((View)iterationDocxTemplaterDocxView);
        return docxTemplaterView;
    }

    @Bean
    DocxTemplaterDocxView campaignDocxTemplaterDocxView() {
        return new DocxTemplaterDocxView();
    }

    @Bean
    DocxTemplaterDocxView iterationDocxTemplaterDocxView() {
        return new DocxTemplaterDocxView();
    }

    @Bean
    ReportQuery campaignReportQuery() {
        CampaignTreeQuery reportQuery = new CampaignTreeQuery();
        return reportQuery;
    }

    @Bean
    ReportQuery iterationReportQuery() {
        IterationTreeQuery reportQuery = new IterationTreeQuery();
        return reportQuery;
    }

    @Bean(name={"org.squashtest.tm.plugin.report.campaignassessment.ValidationService"})
    public ValidationService validationService() {
        return new ValidationServiceImpl();
    }

    @Bean(name={"org.squashtest.tm.plugin.report.campaignassessment.LicenseValidator"})
    public LicenseValidator licenseValidator(@Named(value="org.squashtest.tm.plugin.report.campaignassessment.ValidationService") @Named(value="org.squashtest.tm.plugin.report.campaignassessment.ValidationService") ValidationService service) {
        return new LicenseValidator(service);
    }

    private String generateCustomTemplateFolderPath(String templateFolder) {
        return String.format("%s/%s/", this.reportCustomTemplateFolderPath, templateFolder);
    }

    private List<OptionInput> generateTemplateDefaultOption() {
        ArrayList<OptionInput> options = new ArrayList<OptionInput>();
        OptionInput defaultOption = new OptionInput(DEFAULT_TEMPLATE_VALUE);
        defaultOption.setDefaultSelected(true);
        defaultOption.setLabelKey("report.campaignexecution.default-template.label");
        defaultOption.setMessageSource(this.messageSource);
        options.add(defaultOption);
        return options;
    }
}

