/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.service;

import bugzilla.org.apache.xmlrpc.XmlRpcException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.exception.BugzillaXmlrpcException;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.service.AbstractCacheService;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.service.BugzillaGlobalFieldsCache;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.service.CacheService;

public class GlobalCacheServiceImpl
extends AbstractCacheService
implements CacheService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalCacheServiceImpl.class);
    private final String bugTrackerUrl;

    public GlobalCacheServiceImpl(String bugTrackerUrl) {
        this.bugTrackerUrl = String.valueOf(bugTrackerUrl) + this.trailingSlash(bugTrackerUrl);
    }

    @Override
    public List<Map<String, Object>> getAllFields() {
        LOGGER.trace("#getAllFieldsForBugTrackerUrl(String) - Getting all fields for bug tracker url " + this.bugTrackerUrl);
        if (Objects.isNull(BugzillaGlobalFieldsCache.getBugTrackerUrlToFieldsMap().get(this.bugTrackerUrl))) {
            LOGGER.debug("#getAllFieldsForBugTrackerUrl(String) - No fields are cached for bug tracker url  " + this.bugTrackerUrl);
            this.refreshOrEmptyCache();
            LOGGER.debug("#getAllFieldsForBugTrackerUrl(String) - Fields are now cached for bug tracker url  " + this.bugTrackerUrl);
        }
        LOGGER.debug("#getAllFieldsForBugTrackerUrl(String) - Fields are cached for bug tracker url  " + this.bugTrackerUrl);
        return BugzillaGlobalFieldsCache.getBugTrackerUrlToFieldsMap().get(this.bugTrackerUrl);
    }

    public void refreshOrEmptyCache() {
        try {
            BugzillaGlobalFieldsCache.getBugTrackerUrlToFieldsMap().put(this.bugTrackerUrl, this.retrieveFields(this.bugTrackerUrl));
        }
        catch (XmlRpcException ex) {
            LOGGER.error("An error occurred while retrieving fields from bugzilla for bug tracker url " + this.bugTrackerUrl);
            this.emptyCache();
            LOGGER.info("Bugzilla fields cache was emptied for bug tracker url " + this.bugTrackerUrl + ". Scheduled task to refresh this cache was cancelled.");
            throw new BugzillaXmlrpcException(ex);
        }
    }

    private void emptyCache() {
        BugzillaGlobalFieldsCache.getBugTrackerUrlToFieldsMap().remove(this.bugTrackerUrl);
        LOGGER.debug("#emptyAllFieldsForBugTrackerUrl(String) - Emptied fields cache for bug tracker url " + this.bugTrackerUrl);
    }

    @Override
    public List<Map<String, Object>> getNonCustomFields() {
        LOGGER.trace("#getNonCustomFieldsForBugTrackerUrl(String) - Getting non custom fields for bug tracker url " + this.bugTrackerUrl);
        return this.getAllFields().stream().filter(this::isFieldUseful).collect(Collectors.toList());
    }

    @Override
    public List<Map<String, Object>> getCustomFields() {
        LOGGER.trace("#getCustomFieldsForBugTrackerUrl(String) - Getting custom fields for bug tracker url " + this.bugTrackerUrl);
        return this.getAllFields().stream().filter(this::isFieldCustom).collect(Collectors.toList());
    }
}

