/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.service;

import bugzilla.org.apache.commons.httpclient.HttpClient;
import bugzilla.org.apache.xmlrpc.XmlRpcException;
import bugzilla.org.apache.xmlrpc.client.XmlRpcClient;
import bugzilla.org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import bugzilla.org.apache.xmlrpc.client.XmlRpcCommonsTransportFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCacheService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCacheService.class);
    private static final String XMLRPC = "xmlrpc.cgi";
    protected static final String FIELDS = "fields";
    protected static final String GET_FIELDS = "Bug.fields";
    protected static final String NAME = "name";
    protected static final String IS_CUSTOM_FIELD = "is_custom";
    protected static final String IS_AVAILABLE_ON_BUG_CREATION = "is_on_bug_entry";
    protected static final String INCLUDE_FIELDS = "include_fields";
    protected static final String VALUES = "values";
    protected static final List<String> NON_CUSTOM_FIELD_NAMES;
    protected static final List<String> INCLUDED_FIELDS_IN_GET_FIELD_COMMAND;

    static {
        ArrayList<String> initialList = new ArrayList<String>(Arrays.asList("target_milestone", "version", "assigned_to", "component", "priority", "short_desc", "longdesc", "op_sys", "bug_severity", "product", "rep_platform"));
        NON_CUSTOM_FIELD_NAMES = Collections.unmodifiableList(initialList);
        ArrayList<String> initialSet = new ArrayList<String>(Arrays.asList(NAME, "display_name", "is_mandatory", "type", "visibility_field", IS_CUSTOM_FIELD, IS_AVAILABLE_ON_BUG_CREATION, VALUES, "visibility_values"));
        INCLUDED_FIELDS_IN_GET_FIELD_COMMAND = Collections.unmodifiableList(initialSet);
    }

    protected List<Map<String, Object>> retrieveFields(String bugTrackerUrl) throws XmlRpcException {
        Map<String, List<String>> executionData = Collections.singletonMap(INCLUDE_FIELDS, INCLUDED_FIELDS_IN_GET_FIELD_COMMAND);
        List<Map<String, List<String>>> params = Collections.singletonList(executionData);
        LOGGER.trace("#retrieveFields(String) - Retrieving fields from bugzilla for bug tracker url " + bugTrackerUrl);
        Map result = (Map)this.getXmlRpcClient(bugTrackerUrl).execute(GET_FIELDS, params);
        LOGGER.debug("#retrieveFields(String) - Retrieved fields from bugzilla for bug tracker url " + bugTrackerUrl);
        return Arrays.stream((Object[])result.get(FIELDS)).map(rawField -> (Map)rawField).filter(field -> this.isFieldUseful((Map<String, Object>)field) || this.isFieldCustom((Map<String, Object>)field)).collect(Collectors.toList());
    }

    protected XmlRpcClient getXmlRpcClient(String serverURL) {
        try {
            XmlRpcClient rpcClient = new XmlRpcClient();
            String apiURL = String.valueOf(serverURL) + this.trailingSlash(serverURL) + XMLRPC;
            XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
            config.setServerURL(new URL(apiURL));
            config.setEnabledForExtensions(true);
            rpcClient.setConfig(config);
            rpcClient.setTransportFactory(this.getTransportFactory(rpcClient));
            return rpcClient;
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException();
        }
    }

    protected String trailingSlash(String serverURL) {
        return serverURL.endsWith("/") ? "" : "/";
    }

    private XmlRpcCommonsTransportFactory getTransportFactory(XmlRpcClient rpcClient) {
        HttpClient httpClient = new HttpClient();
        XmlRpcCommonsTransportFactory factory = new XmlRpcCommonsTransportFactory(rpcClient);
        factory.setHttpClient(httpClient);
        return factory;
    }

    protected boolean isFieldUseful(Map<String, Object> field) {
        return field.get(IS_CUSTOM_FIELD).equals(false) && NON_CUSTOM_FIELD_NAMES.contains((String)field.get(NAME));
    }

    protected boolean isFieldCustom(Map<String, Object> field) {
        return field.get(IS_CUSTOM_FIELD).equals(true) && field.get(IS_AVAILABLE_ON_BUG_CREATION).equals(true);
    }
}

