/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.bugzilla.internal;

import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;

@Component
public class BugzillaBugTrackerInterfaceDescriptor
implements BugTrackerInterfaceDescriptor {
    private ThreadLocal<Locale> locale = new ThreadLocal();
    @Inject
    @Named(value="bugzillaConnectorMessageSource")
    private MessageSource messageSource;

    private Locale getLocale() {
        Locale loc = this.locale.get();
        return loc == null ? LocaleContextHolder.getLocale() : loc;
    }

    public String getReportPriorityLabel() {
        return this.getMessage("interface.report.priority.label");
    }

    private String getMessage(String key) {
        return this.messageSource.getMessage(key, null, this.getLocale());
    }

    public String getAttachmentLabel() {
        return this.getMessage("interface.attachment");
    }

    public String getReportVersionLabel() {
        return this.getMessage("interface.report.version.label");
    }

    public String getReportAssigneeLabel() {
        return this.getMessage("interface.report.assignee.label");
    }

    public String getReportCategoryLabel() {
        return this.getMessage("interface.report.category.label");
    }

    public String getReportSummaryLabel() {
        return this.getMessage("interface.report.summary.label");
    }

    public String getReportDescriptionLabel() {
        return this.getMessage("interface.report.description.label");
    }

    public String getReportCommentLabel() {
        return this.getMessage("interface.report.comment.label");
    }

    public String getEmptyVersionListLabel() {
        return this.getMessage("interface.report.lists.emptyversion.label");
    }

    public String getEmptyCategoryListLabel() {
        return this.getMessage("interface.report.lists.emptycategory.label");
    }

    public String getEmptyAssigneeListLabel() {
        return this.getMessage("interface.report.lists.emptyassignee.label");
    }

    public String getTableIssueIDHeader() {
        return this.getMessage("interface.table.issueid.header");
    }

    public String getTableSummaryHeader() {
        return this.getMessage("interface.table.summary.header");
    }

    public String getTablePriorityHeader() {
        return this.getMessage("interface.table.priority.header");
    }

    public String getTableStatusHeader() {
        return this.getMessage("interface.table.status.header");
    }

    public String getTableDescriptionHeader() {
        return this.getMessage("interface.table.description.header");
    }

    public String getTableAssigneeHeader() {
        return this.getMessage("interface.table.assignee.header");
    }

    public String getTableReportedInHeader() {
        return this.getMessage("interface.table.reportedin.header");
    }

    public String getTableNoAssigneeLabel() {
        return this.getMessage("interface.table.null.assignee.label");
    }

    public void setLocale(Locale locale) {
        this.locale.set(locale);
    }

    public boolean getSupportsRichComment() {
        return false;
    }

    public boolean getSupportsRichDescription() {
        return false;
    }

    public String getPlatformLabel() {
        return this.getMessage("interface.report.platform.label");
    }
}

