/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.azuredevops.internal.domain;

import java.util.List;
import javax.validation.constraints.NotNull;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.CustomizationType;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.Process;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.Project;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.WorkItemType;

public class ProjectReferentialData {
    public final String organizationName;
    public final Project project;
    public final String processTemplateTypeId;
    public final List<WorkItemType> workItemTypes;
    public final boolean isSystemProcess;
    public final String rootProcessName;

    public ProjectReferentialData(@NotNull String organizationName, @NotNull Project project, @NotNull String processTemplateTypeId, @NotNull List<WorkItemType> workItemTypes, @NotNull Process process, @NotNull Process rootProcess) {
        this.organizationName = organizationName;
        this.project = project;
        this.processTemplateTypeId = processTemplateTypeId;
        this.workItemTypes = workItemTypes;
        this.isSystemProcess = process.getCustomizationType().equals(CustomizationType.SYSTEM.value);
        this.rootProcessName = rootProcess.getName();
    }

    public String getProjectPath() {
        return String.format("%s/%s", this.organizationName, this.project.getName());
    }
}

