/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.scm.git;

import javax.inject.Inject;
import javax.inject.Provider;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.scm.ScmRepository;
import org.squashtest.tm.domain.scm.ScmServer;
import org.squashtest.tm.plugin.scm.git.internal.GitConnector;
import org.squashtest.tm.plugin.scm.git.internal.RestrictedGitConnector;
import org.squashtest.tm.service.internal.scmserver.ScmConnectorProvider;
import org.squashtest.tm.service.spi.ScmConnector;

@Service
public class GitConnectorProvider
implements ScmConnectorProvider {
    @Inject
    private Provider<GitConnector> connectorProvider;

    public String getScmKind() {
        return "git";
    }

    public ScmConnector createScmConnector(ScmServer scmServer) {
        return new RestrictedGitConnector(scmServer);
    }

    public ScmConnector createScmConnector(ScmRepository scmRepository) {
        GitConnector connector = (GitConnector)this.connectorProvider.get();
        connector.setScmRepository(scmRepository);
        return connector;
    }
}

