/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.springframework.security.saml.websso;

import java.util.List;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLException;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.LogoutRequest;
import org.opensaml.saml2.core.LogoutResponse;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.SessionIndex;
import org.opensaml.saml2.core.Status;
import org.opensaml.saml2.core.StatusMessage;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.encryption.DecryptionException;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.validation.ValidationException;
import org.springframework.util.Assert;
import sqsaml.org.springframework.security.saml.SAMLCredential;
import sqsaml.org.springframework.security.saml.SAMLStatusException;
import sqsaml.org.springframework.security.saml.context.SAMLMessageContext;
import sqsaml.org.springframework.security.saml.storage.SAMLMessageStorage;
import sqsaml.org.springframework.security.saml.util.SAMLUtil;
import sqsaml.org.springframework.security.saml.websso.AbstractProfileBase;
import sqsaml.org.springframework.security.saml.websso.SingleLogoutProfile;

public class SingleLogoutProfileImpl
extends AbstractProfileBase
implements SingleLogoutProfile {
    @Override
    public String getProfileIdentifier() {
        return "urn:oasis:names:tc:SAML:2.0:profiles:SSO:logout";
    }

    @Override
    public void sendLogoutRequest(SAMLMessageContext context, SAMLCredential credential) throws SAMLException, MetadataProviderException, MessageEncodingException {
        if (credential == null) {
            return;
        }
        IDPSSODescriptor idpDescriptor = (IDPSSODescriptor)context.getPeerEntityRoleMetadata();
        SPSSODescriptor spDescriptor = (SPSSODescriptor)context.getLocalEntityRoleMetadata();
        String binding = SAMLUtil.getLogoutBinding(idpDescriptor, spDescriptor);
        SingleLogoutService logoutServiceIDP = SAMLUtil.getLogoutServiceForBinding(idpDescriptor, binding);
        LogoutRequest logoutRequest = this.getLogoutRequest(context, credential, logoutServiceIDP);
        context.setCommunicationProfileId(this.getProfileIdentifier());
        context.setOutboundMessage(logoutRequest);
        context.setOutboundSAMLMessage(logoutRequest);
        context.setPeerEntityEndpoint(logoutServiceIDP);
        SAMLMessageStorage messageStorage = context.getMessageStorage();
        if (messageStorage != null) {
            messageStorage.storeMessage(logoutRequest.getID(), logoutRequest);
        }
        boolean signMessage = context.getPeerExtendedMetadata().isRequireLogoutRequestSigned();
        this.sendMessage(context, signMessage);
    }

    protected LogoutRequest getLogoutRequest(SAMLMessageContext context, SAMLCredential credential, Endpoint bindingService) throws SAMLException, MetadataProviderException {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)this.builderFactory.getBuilder(LogoutRequest.DEFAULT_ELEMENT_NAME);
        LogoutRequest request = (LogoutRequest)builder.buildObject();
        this.buildCommonAttributes(context.getLocalEntityId(), request, bindingService);
        SAMLObjectBuilder sessionIndexBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(SessionIndex.DEFAULT_ELEMENT_NAME);
        for (AuthnStatement statement : credential.getAuthenticationAssertion().getAuthnStatements()) {
            SessionIndex index = (SessionIndex)sessionIndexBuilder.buildObject();
            index.setSessionIndex(statement.getSessionIndex());
            request.getSessionIndexes().add(index);
        }
        if (request.getSessionIndexes().size() == 0) {
            throw new SAMLException("No session indexes to logout user for were found");
        }
        SAMLObjectBuilder nameIDBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(NameID.DEFAULT_ELEMENT_NAME);
        NameID nameID = (NameID)nameIDBuilder.buildObject();
        nameID.setFormat(credential.getNameID().getFormat());
        nameID.setNameQualifier(credential.getNameID().getNameQualifier());
        nameID.setSPNameQualifier(credential.getNameID().getSPNameQualifier());
        nameID.setSPProvidedID(credential.getNameID().getSPProvidedID());
        nameID.setValue(credential.getNameID().getValue());
        request.setNameID(nameID);
        return request;
    }

    @Override
    public boolean processLogoutRequest(SAMLMessageContext context, SAMLCredential credential) throws SAMLException {
        Object message = context.getInboundSAMLMessage();
        if (message == null || !(message instanceof LogoutRequest)) {
            throw new SAMLException("Message is not of a LogoutRequest object type");
        }
        LogoutRequest logoutRequest = (LogoutRequest)message;
        if (!context.isInboundSAMLMessageAuthenticated() && context.getLocalExtendedMetadata().isRequireLogoutRequestSigned()) {
            throw new SAMLStatusException("urn:oasis:names:tc:SAML:2.0:status:RequestDenied", "LogoutRequest is required to be signed by the entity policy");
        }
        try {
            this.verifyEndpoint(context.getLocalEntityEndpoint(), logoutRequest.getDestination());
        }
        catch (SAMLException e) {
            throw new SAMLStatusException("urn:oasis:names:tc:SAML:2.0:status:RequestDenied", "Destination of the LogoutRequest does not match any of the single logout endpoints");
        }
        try {
            if (logoutRequest.getIssuer() != null) {
                Issuer issuer = logoutRequest.getIssuer();
                this.verifyIssuer(issuer, context);
            }
        }
        catch (SAMLException e) {
            throw new SAMLStatusException("urn:oasis:names:tc:SAML:2.0:status:RequestDenied", "Issuer of the LogoutRequest is unknown");
        }
        DateTime time = logoutRequest.getIssueInstant();
        if (!SAMLUtil.isDateTimeSkewValid(this.getResponseSkew(), time)) {
            throw new SAMLStatusException("urn:oasis:names:tc:SAML:2.0:status:Requester", "LogoutRequest issue instant is either too old or with date in the future");
        }
        if (credential == null) {
            throw new SAMLStatusException("urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipal", "No user is logged in");
        }
        boolean indexFound = false;
        if (logoutRequest.getSessionIndexes() != null && logoutRequest.getSessionIndexes().size() > 0) {
            for (AuthnStatement statement : credential.getAuthenticationAssertion().getAuthnStatements()) {
                String statementIndex = statement.getSessionIndex();
                if (statementIndex == null) continue;
                for (SessionIndex index : logoutRequest.getSessionIndexes()) {
                    if (!statementIndex.equals(index.getSessionIndex())) continue;
                    indexFound = true;
                }
            }
        } else {
            indexFound = true;
        }
        if (!indexFound) {
            throw new SAMLStatusException("urn:oasis:names:tc:SAML:2.0:status:Requester", "The SessionIndex was not found");
        }
        try {
            NameID nameID = this.getNameID(context, logoutRequest);
            if (nameID == null || !this.equalsNameID(credential.getNameID(), nameID)) {
                throw new SAMLStatusException("urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipal", "The requested NameID is invalid");
            }
        }
        catch (DecryptionException e) {
            throw new SAMLStatusException("urn:oasis:names:tc:SAML:2.0:status:Responder", "The NameID can't be decrypted", e);
        }
        return true;
    }

    @Override
    public void sendLogoutResponse(SAMLMessageContext context, String statusCode, String statusMessage) throws MetadataProviderException, SAMLException, MessageEncodingException {
        SAMLObjectBuilder responseBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(LogoutResponse.DEFAULT_ELEMENT_NAME);
        LogoutResponse logoutResponse = (LogoutResponse)responseBuilder.buildObject();
        IDPSSODescriptor idpDescriptor = SAMLUtil.getIDPDescriptor(this.metadata, context.getPeerEntityId());
        SPSSODescriptor spDescriptor = (SPSSODescriptor)context.getLocalEntityRoleMetadata();
        String binding = SAMLUtil.getLogoutBinding(idpDescriptor, spDescriptor);
        SingleLogoutService logoutService = SAMLUtil.getLogoutServiceForBinding(idpDescriptor, binding);
        logoutResponse.setID(this.generateID());
        logoutResponse.setIssuer(this.getIssuer(context.getLocalEntityId()));
        logoutResponse.setVersion(SAMLVersion.VERSION_20);
        logoutResponse.setIssueInstant(new DateTime());
        logoutResponse.setInResponseTo(context.getInboundSAMLMessageId());
        logoutResponse.setDestination(logoutService.getLocation());
        Status status = this.getStatus(statusCode, statusMessage);
        logoutResponse.setStatus(status);
        context.setCommunicationProfileId(this.getProfileIdentifier());
        context.setOutboundMessage(logoutResponse);
        context.setOutboundSAMLMessage(logoutResponse);
        context.setPeerEntityEndpoint(logoutService);
        context.setPeerEntityRoleMetadata(idpDescriptor);
        boolean signMessage = context.getPeerExtendedMetadata().isRequireLogoutResponseSigned();
        this.sendMessage(context, signMessage);
    }

    private boolean equalsNameID(NameID a, NameID b) {
        boolean equals = !this.differ(a.getSPProvidedID(), b.getSPProvidedID());
        equals = equals && !this.differ(a.getValue(), b.getValue());
        equals = equals && !this.differ(a.getFormat(), b.getFormat());
        equals = equals && !this.differ(a.getNameQualifier(), b.getNameQualifier());
        equals = equals && !this.differ(a.getSPNameQualifier(), b.getSPNameQualifier());
        equals = equals && !this.differ(a.getSPProvidedID(), b.getSPProvidedID());
        return equals;
    }

    private boolean differ(Object a, Object b) {
        if (a == null) {
            return b != null;
        }
        return !a.equals(b);
    }

    protected NameID getNameID(SAMLMessageContext context, LogoutRequest request) throws DecryptionException {
        NameID id;
        if (request.getEncryptedID() != null) {
            Assert.notNull((Object)context.getLocalDecrypter(), (String)"Can't decrypt NameID, no decrypter is set in the context");
            id = (NameID)context.getLocalDecrypter().decrypt(request.getEncryptedID());
        } else {
            id = request.getNameID();
        }
        return id;
    }

    @Override
    public void processLogoutResponse(SAMLMessageContext context) throws SAMLException, SecurityException, ValidationException {
        String statusCode;
        Object message = context.getInboundSAMLMessage();
        if (!(message instanceof LogoutResponse)) {
            throw new SAMLException("Message is not of a LogoutResponse object type");
        }
        LogoutResponse response = (LogoutResponse)message;
        if (!context.isInboundSAMLMessageAuthenticated() && context.getLocalExtendedMetadata().isRequireLogoutResponseSigned()) {
            throw new SAMLException("Logout Response object is required to be signed by the entity policy: " + context.getInboundSAMLMessageId());
        }
        DateTime time = response.getIssueInstant();
        if (!SAMLUtil.isDateTimeSkewValid(this.getResponseSkew(), time)) {
            throw new SAMLException("Response issue time in LogoutResponse is either too old or with date in the future");
        }
        SAMLMessageStorage messageStorage = context.getMessageStorage();
        if (messageStorage != null && response.getInResponseTo() != null) {
            XMLObject xmlObject = messageStorage.retrieveMessage(response.getInResponseTo());
            if (xmlObject == null) {
                throw new SAMLException("InResponseToField in LogoutResponse doesn't correspond to sent message " + response.getInResponseTo());
            }
            if (!(xmlObject instanceof LogoutRequest)) {
                throw new SAMLException("Sent request was of different type than the expected LogoutRequest " + response.getInResponseTo());
            }
        }
        if (response.getDestination() != null) {
            SPSSODescriptor localDescriptor = (SPSSODescriptor)context.getLocalEntityRoleMetadata();
            List<SingleLogoutService> services = localDescriptor.getSingleLogoutServices();
            boolean found = false;
            for (SingleLogoutService service : services) {
                if (!response.getDestination().equals(service.getLocation()) || !context.getInboundSAMLBinding().equals(service.getBinding())) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new SAMLException("Destination in the LogoutResponse was not the expected value " + response.getDestination());
            }
        }
        if (response.getIssuer() != null) {
            Issuer issuer = response.getIssuer();
            this.verifyIssuer(issuer, context);
        }
        if ("urn:oasis:names:tc:SAML:2.0:status:Success".equals(statusCode = response.getStatus().getStatusCode().getValue())) {
            this.log.debug("Single Logout was successful");
        } else if ("urn:oasis:names:tc:SAML:2.0:status:PartialLogout".equals(statusCode)) {
            this.log.debug("Single Logout was partially successful");
        } else {
            String message1 = response.getStatus().getStatusCode().getValue();
            String message2 = "N/A";
            StatusMessage status = response.getStatus().getStatusMessage();
            if (status != null) {
                message2 = status.getMessage();
            }
            this.log.warn("Received LogoutResponse has invalid status code: %s; message: %s", (Object)message1, (Object)message2);
        }
    }
}

