/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.springframework.security.saml.metadata;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.io.MarshallingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.web.FilterInvocation;
import org.springframework.util.Assert;
import org.springframework.web.filter.GenericFilterBean;
import sqsaml.org.springframework.security.saml.context.SAMLContextProvider;
import sqsaml.org.springframework.security.saml.context.SAMLMessageContext;
import sqsaml.org.springframework.security.saml.key.KeyManager;
import sqsaml.org.springframework.security.saml.metadata.MetadataManager;
import sqsaml.org.springframework.security.saml.util.SAMLUtil;

public class MetadataDisplayFilter
extends GenericFilterBean {
    protected static final Logger log = LoggerFactory.getLogger(MetadataDisplayFilter.class);
    protected MetadataManager manager;
    protected KeyManager keyManager;
    protected SAMLContextProvider contextProvider;
    protected String filterProcessesUrl = "/saml/metadata";
    public static final String FILTER_URL = "/saml/metadata";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        FilterInvocation fi = new FilterInvocation(request, response, chain);
        if (!this.processFilter(fi.getRequest())) {
            chain.doFilter(request, response);
            return;
        }
        this.processMetadataDisplay(fi.getRequest(), fi.getResponse());
    }

    protected boolean processFilter(HttpServletRequest request) {
        return SAMLUtil.processFilter(this.filterProcessesUrl, request);
    }

    protected void processMetadataDisplay(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            SAMLMessageContext context = this.contextProvider.getLocalEntity(request, response);
            String entityId = context.getLocalEntityId();
            response.setContentType("application/samlmetadata+xml");
            response.setCharacterEncoding("UTF-8");
            response.addHeader("Content-Disposition", "attachment; filename=\"spring_saml_metadata.xml\"");
            this.displayMetadata(entityId, response.getWriter());
        }
        catch (MetadataProviderException e) {
            throw new ServletException("Error initializing metadata", (Throwable)e);
        }
    }

    protected void displayMetadata(String spEntityName, PrintWriter writer) throws ServletException {
        try {
            EntityDescriptor descriptor = this.manager.getEntityDescriptor(spEntityName);
            if (descriptor == null) {
                throw new ServletException("Metadata entity with ID " + this.manager.getHostedSPName() + " wasn't found");
            }
            writer.print(this.getMetadataAsString(descriptor));
        }
        catch (MarshallingException e) {
            log.error("Error marshalling entity descriptor", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        catch (MetadataProviderException e) {
            log.error("Error retrieving metadata", (Throwable)e);
            throw new ServletException("Error retrieving metadata", (Throwable)e);
        }
    }

    protected String getMetadataAsString(EntityDescriptor descriptor) throws MarshallingException {
        return SAMLUtil.getMetadataAsString(this.manager, this.keyManager, descriptor, null);
    }

    @Autowired
    public void setManager(MetadataManager manager) {
        this.manager = manager;
    }

    @Autowired
    public void setContextProvider(SAMLContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    @Autowired
    public void setKeyManager(KeyManager keyManager) {
        this.keyManager = keyManager;
    }

    public String getFilterProcessesUrl() {
        return this.filterProcessesUrl;
    }

    public void setFilterProcessesUrl(String filterProcessesUrl) {
        this.filterProcessesUrl = filterProcessesUrl;
    }

    public void afterPropertiesSet() throws ServletException {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.manager, (String)"MetadataManager must be set");
        Assert.notNull((Object)this.keyManager, (String)"KeyManager must be set");
        Assert.notNull((Object)this.contextProvider, (String)"Context provider must be set");
    }
}

