/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.springframework.security.saml;

import java.io.IOException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.common.SAMLException;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.samlext.idpdisco.DiscoveryResponse;
import org.opensaml.util.URLBuilder;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.web.FilterInvocation;
import org.springframework.util.Assert;
import org.springframework.web.filter.GenericFilterBean;
import sqsaml.org.springframework.security.saml.SAMLEntryPoint;
import sqsaml.org.springframework.security.saml.context.SAMLContextProvider;
import sqsaml.org.springframework.security.saml.context.SAMLMessageContext;
import sqsaml.org.springframework.security.saml.metadata.ExtendedMetadata;
import sqsaml.org.springframework.security.saml.metadata.MetadataManager;
import sqsaml.org.springframework.security.saml.util.SAMLUtil;

public class SAMLDiscovery
extends GenericFilterBean {
    protected static final Logger log = LoggerFactory.getLogger(SAMLDiscovery.class);
    public static final String RETURN_URL = "idpDiscoReturnURL";
    public static final String RETURN_PARAM = "idpDiscoReturnParam";
    public static final String ENTITY_ID_PARAM = "entityID";
    public static final String RETURN_URL_PARAM = "return";
    public static final String RETURN_ID_PARAM = "returnIDParam";
    public static final String POLICY_PARAM = "policy";
    public static final String PASSIVE_PARAM = "isPassive";
    protected String idpSelectionPath;
    protected MetadataManager metadata;
    protected SAMLContextProvider contextProvider;
    protected SAMLEntryPoint samlEntryPoint;
    protected String filterProcessesUrl = "/saml/discovery";
    public static final String FILTER_URL = "/saml/discovery";
    public static final String IDP_DISCO_PROTOCOL_SINGLE = "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol:single";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        FilterInvocation fi = new FilterInvocation(request, response, chain);
        if (!this.processFilter(fi.getRequest())) {
            chain.doFilter(request, response);
            return;
        }
        this.processDiscoveryRequest(fi.getRequest(), fi.getResponse());
    }

    protected boolean processFilter(HttpServletRequest request) {
        return SAMLUtil.processFilter(this.filterProcessesUrl, request);
    }

    protected void processDiscoveryRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String isPassive;
        SAMLMessageContext messageContext;
        log.debug("Processing IDP Discovery Service request");
        String entityId = request.getParameter(ENTITY_ID_PARAM);
        if (entityId == null) {
            log.debug("Received IDP Discovery request without entityId");
            throw new ServletException((Throwable)new SAMLException("Entity ID parameter must be specified"));
        }
        try {
            request.setAttribute("localEntityId", (Object)entityId);
            messageContext = this.contextProvider.getLocalEntity(request, response);
        }
        catch (MetadataProviderException e) {
            log.debug("Error loading metadata", (Throwable)e);
            throw new ServletException((Throwable)new SAMLException("Error loading metadata", e));
        }
        String returnURL = request.getParameter(RETURN_URL_PARAM);
        if (returnURL == null) {
            returnURL = this.getDefaultReturnURL(messageContext);
        } else if (!this.isResponseURLValid(returnURL, messageContext)) {
            log.debug("Return URL {} designated in IDP Discovery request for entity {} is not valid", (Object)returnURL, (Object)entityId);
            throw new ServletException((Throwable)new SAMLException("Return URL designated in IDP Discovery request for entity is not valid"));
        }
        if (returnURL == null) {
            throw new ServletException((Throwable)new SAMLException("Can't determine IDP Discovery return URL for entity " + messageContext.getLocalEntityRoleMetadata().getID()));
        }
        String policy = request.getParameter(POLICY_PARAM);
        if (policy != null && !policy.equals(IDP_DISCO_PROTOCOL_SINGLE)) {
            log.debug("Received IDP Discovery with unsupported policy {}", (Object)policy);
            throw new ServletException((Throwable)new SAMLException("Unsupported IDP discovery profile was requested"));
        }
        String returnParam = request.getParameter(RETURN_ID_PARAM);
        if (returnParam == null) {
            returnParam = ENTITY_ID_PARAM;
        }
        if ((isPassive = request.getParameter(PASSIVE_PARAM)) != null && "true".equals(isPassive)) {
            String passiveIDP = this.getPassiveIDP(request);
            this.sendPassiveResponse(request, response, returnURL, returnParam, passiveIDP);
        } else if (this.getIdpSelectionPath() == null) {
            log.debug("No IDP selection path configured, sending passive response");
            String passiveIDP = this.getPassiveIDP(request);
            this.sendPassiveResponse(request, response, returnURL, returnParam, passiveIDP);
        } else {
            this.sendIDPSelection(request, response, returnURL, returnParam);
        }
    }

    protected void sendPassiveResponse(HttpServletRequest request, HttpServletResponse response, String responseURL, String returnParam, String entityID) throws IOException, ServletException {
        String finalResponseURL = responseURL;
        if (entityID != null) {
            URLBuilder urlBuilder = new URLBuilder(responseURL);
            List<Pair<String, String>> queryParams = urlBuilder.getQueryParams();
            queryParams.add(new Pair<String, String>(returnParam, entityID));
            finalResponseURL = urlBuilder.buildURL();
        }
        log.debug("Responding to a passive IDP Discovery request with URL {}", (Object)finalResponseURL);
        response.sendRedirect(finalResponseURL);
    }

    protected void sendIDPSelection(HttpServletRequest request, HttpServletResponse response, String responseURL, String returnParam) throws IOException, ServletException {
        request.setAttribute(RETURN_URL, (Object)responseURL);
        request.setAttribute(RETURN_PARAM, (Object)returnParam);
        String path = this.getIdpSelectionPath();
        log.debug("Initializing IDP Discovery selection page at {} with return url {}", (Object)path, (Object)responseURL);
        request.getRequestDispatcher(path).forward((ServletRequest)request, (ServletResponse)response);
    }

    protected String getDefaultReturnURL(SAMLMessageContext messageContext) {
        RoleDescriptor descriptor = messageContext.getLocalEntityRoleMetadata();
        ExtendedMetadata extendedMetadata = messageContext.getLocalExtendedMetadata();
        if (extendedMetadata.isLocal() && extendedMetadata.getIdpDiscoveryResponseURL() != null) {
            return extendedMetadata.getIdpDiscoveryResponseURL();
        }
        if (descriptor.getExtensions() != null) {
            List<XMLObject> discoveryResponseElements = descriptor.getExtensions().getUnknownXMLObjects(DiscoveryResponse.DEFAULT_ELEMENT_NAME);
            for (XMLObject element : discoveryResponseElements) {
                DiscoveryResponse response = (DiscoveryResponse)element;
                if (!response.getBinding().equals("urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol")) continue;
                log.debug("Using IDP Discovery response URL from metadata {}", (Object)response.getLocation());
                return response.getLocation();
            }
        }
        if (extendedMetadata.isLocal()) {
            String filterUrl = "/saml/login";
            if (this.samlEntryPoint != null) {
                filterUrl = this.samlEntryPoint.getFilterProcessesUrl();
            }
            String contextPath = (String)messageContext.getInboundMessageTransport().getAttribute("localContextPath");
            String responseURL = contextPath + filterUrl + (extendedMetadata.getAlias() != null ? "/alias/" + extendedMetadata.getAlias() : "") + "?" + "disco" + "=true";
            log.debug("Using IDP Discovery response URL calculated for local entity {}", (Object)responseURL);
            return responseURL;
        }
        return null;
    }

    protected boolean isResponseURLValid(String returnURL, SAMLMessageContext messageContext) {
        URLBuilder foundURL = new URLBuilder(returnURL);
        URLBuilder defaultURL = new URLBuilder(this.getDefaultReturnURL(messageContext));
        return defaultURL.getHost().equals(foundURL.getHost());
    }

    protected String getPassiveIDP(HttpServletRequest request) {
        try {
            return this.metadata.getDefaultIDP();
        }
        catch (MetadataProviderException e) {
            return null;
        }
    }

    public String getIdpSelectionPath() {
        return this.idpSelectionPath;
    }

    public void setIdpSelectionPath(String idpSelectionPath) {
        this.idpSelectionPath = idpSelectionPath;
    }

    @Autowired
    public void setMetadata(MetadataManager metadata) {
        Assert.notNull((Object)metadata, (String)"MetadataManager can't be null");
        this.metadata = metadata;
    }

    @Autowired(required=false)
    public void setSamlEntryPoint(SAMLEntryPoint samlEntryPoint) {
        this.samlEntryPoint = samlEntryPoint;
    }

    @Autowired
    public void setContextProvider(SAMLContextProvider contextProvider) {
        Assert.notNull((Object)contextProvider, (String)"Context provider can't be null");
        this.contextProvider = contextProvider;
    }

    public String getFilterProcessesUrl() {
        return this.filterProcessesUrl;
    }

    public void setFilterProcessesUrl(String filterProcessesUrl) {
        this.filterProcessesUrl = filterProcessesUrl;
    }

    public void afterPropertiesSet() throws ServletException {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.metadata, (String)"Metadata must be set");
        Assert.notNull((Object)this.contextProvider, (String)"Context provider must be set");
    }
}

