/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.springframework.security.providers;

import java.util.Collection;
import java.util.Date;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

public class ExpiringUsernameAuthenticationToken
extends UsernamePasswordAuthenticationToken {
    private Date tokenExpiration;

    public ExpiringUsernameAuthenticationToken(Object principal, Object credentials) {
        super(principal, credentials);
    }

    public ExpiringUsernameAuthenticationToken(Date tokenExpiration, Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(principal, credentials, authorities);
        this.tokenExpiration = tokenExpiration;
    }

    public boolean isAuthenticated() {
        if (this.tokenExpiration != null && new Date().compareTo(this.tokenExpiration) >= 0) {
            return false;
        }
        return super.isAuthenticated();
    }

    public Date getTokenExpiration() {
        return this.tokenExpiration;
    }

    public void eraseCredentials() {
    }
}

