/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.owasp.esapi.waf.rules;

import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sqsaml.org.owasp.esapi.waf.actions.Action;
import sqsaml.org.owasp.esapi.waf.actions.DefaultAction;
import sqsaml.org.owasp.esapi.waf.actions.DoNothingAction;
import sqsaml.org.owasp.esapi.waf.internal.InterceptingHTTPServletResponse;
import sqsaml.org.owasp.esapi.waf.rules.Rule;

public class HTTPMethodRule
extends Rule {
    private Pattern allowedMethods;
    private Pattern deniedMethods;
    private Pattern path;

    public HTTPMethodRule(String id, Pattern allowedMethods, Pattern deniedMethods, Pattern path) {
        this.allowedMethods = allowedMethods;
        this.deniedMethods = deniedMethods;
        this.path = path;
        this.setId(id);
    }

    @Override
    public Action check(HttpServletRequest request, InterceptingHTTPServletResponse response, HttpServletResponse httpResponse) {
        String uri = request.getRequestURI();
        String method = request.getMethod();
        if (this.path == null || this.path.matcher(uri).matches()) {
            if (this.allowedMethods != null && this.allowedMethods.matcher(method).matches()) {
                return new DoNothingAction();
            }
            if (this.allowedMethods != null) {
                this.log(request, "Disallowed HTTP method '" + request.getMethod() + "' found for URL: " + request.getRequestURL());
                return new DefaultAction();
            }
            if (this.deniedMethods != null && this.deniedMethods.matcher(method).matches()) {
                this.log(request, "Disallowed HTTP method '" + request.getMethod() + "' found for URL: " + request.getRequestURL());
                return new DefaultAction();
            }
        }
        return new DoNothingAction();
    }
}

