/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.owasp.esapi.reference.accesscontrol;

import java.util.Map;
import sqsaml.org.owasp.esapi.AccessControlRule;
import sqsaml.org.owasp.esapi.AccessController;
import sqsaml.org.owasp.esapi.ESAPI;
import sqsaml.org.owasp.esapi.Logger;
import sqsaml.org.owasp.esapi.errors.AccessControlException;
import sqsaml.org.owasp.esapi.reference.accesscontrol.policyloader.ACRPolicyFileLoader;
import sqsaml.org.owasp.esapi.reference.accesscontrol.policyloader.PolicyDTO;

public class ExperimentalAccessController
implements AccessController {
    private Map ruleMap;
    protected final Logger logger = ESAPI.getLogger("DefaultAccessController");

    public ExperimentalAccessController(Map ruleMap) {
        this.ruleMap = ruleMap;
    }

    public ExperimentalAccessController() throws AccessControlException {
        ACRPolicyFileLoader policyDescriptor = new ACRPolicyFileLoader();
        PolicyDTO policyDTO = policyDescriptor.load();
        this.ruleMap = policyDTO.getAccessControlRules();
    }

    @Override
    public boolean isAuthorized(Object key, Object runtimeParameter) {
        try {
            AccessControlRule rule = (AccessControlRule)this.ruleMap.get(key);
            if (rule == null) {
                throw new AccessControlException("Access Denied", "AccessControlRule was not found for key: " + key);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(Logger.EVENT_SUCCESS, "Evaluating Authorization Rule \"" + key + "\" Using class: " + rule.getClass().getCanonicalName());
            }
            return rule.isAuthorized(runtimeParameter);
        }
        catch (Exception e) {
            try {
                throw new AccessControlException("Access Denied", "An unhandled Exception was caught, so access is denied.", e);
            }
            catch (AccessControlException accessControlException) {
                return false;
            }
        }
    }

    @Override
    public void assertAuthorized(Object key, Object runtimeParameter) throws AccessControlException {
        boolean isAuthorized = false;
        try {
            AccessControlRule rule = (AccessControlRule)this.ruleMap.get(key);
            if (rule == null) {
                throw new AccessControlException("Access Denied", "AccessControlRule was not found for key: " + key);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(Logger.EVENT_SUCCESS, "Asserting Authorization Rule \"" + key + "\" Using class: " + rule.getClass().getCanonicalName());
            }
            isAuthorized = rule.isAuthorized(runtimeParameter);
        }
        catch (Exception e) {
            throw new AccessControlException("Access Denied", "An unhandled Exception was caught, so access is denied.AccessControlException.", e);
        }
        if (!isAuthorized) {
            throw new AccessControlException("Access Denied", "Access Denied for key: " + key + " runtimeParameter: " + runtimeParameter);
        }
    }

    @Override
    @Deprecated
    public void assertAuthorizedForData(String action, Object data) throws AccessControlException {
        this.assertAuthorized("AC 1.0 Data", new Object[]{action, data});
    }

    @Override
    @Deprecated
    public void assertAuthorizedForFile(String filepath) throws AccessControlException {
        this.assertAuthorized("AC 1.0 File", new Object[]{filepath});
    }

    @Override
    @Deprecated
    public void assertAuthorizedForFunction(String functionName) throws AccessControlException {
        this.assertAuthorized("AC 1.0 Function", new Object[]{functionName});
    }

    @Override
    @Deprecated
    public void assertAuthorizedForService(String serviceName) throws AccessControlException {
        this.assertAuthorized("AC 1.0 Service", new Object[]{serviceName});
    }

    @Override
    @Deprecated
    public void assertAuthorizedForURL(String url) throws AccessControlException {
        this.assertAuthorized("AC 1.0 URL", new Object[]{url});
    }

    @Override
    @Deprecated
    public boolean isAuthorizedForData(String action, Object data) {
        return this.isAuthorized("AC 1.0 Data", new Object[]{action, data});
    }

    @Override
    @Deprecated
    public boolean isAuthorizedForFile(String filepath) {
        return this.isAuthorized("AC 1.0 File", new Object[]{filepath});
    }

    @Override
    @Deprecated
    public boolean isAuthorizedForFunction(String functionName) {
        return this.isAuthorized("AC 1.0 Function", new Object[]{functionName});
    }

    @Override
    @Deprecated
    public boolean isAuthorizedForService(String serviceName) {
        return this.isAuthorized("AC 1.0 Service", new Object[]{serviceName});
    }

    @Override
    @Deprecated
    public boolean isAuthorizedForURL(String url) {
        return this.isAuthorized("AC 1.0 URL", new Object[]{url});
    }
}

