/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.owasp.esapi.logging.appender;

import sqsaml.org.owasp.esapi.Logger;
import sqsaml.org.owasp.esapi.logging.appender.ClientInfoSupplier;
import sqsaml.org.owasp.esapi.logging.appender.EventTypeLogSupplier;
import sqsaml.org.owasp.esapi.logging.appender.LogAppender;
import sqsaml.org.owasp.esapi.logging.appender.ServerInfoSupplier;
import sqsaml.org.owasp.esapi.logging.appender.UserInfoSupplier;

public class LogPrefixAppender
implements LogAppender {
    private static final String RESULT_FORMAT = "[%s] %s";
    private final boolean logUserInfo;
    private final boolean logClientInfo;
    private final boolean logServerIp;
    private final boolean logApplicationName;
    private final String appName;

    public LogPrefixAppender(boolean logUserInfo, boolean logClientInfo, boolean logServerIp, boolean logApplicationName, String appName) {
        this.logUserInfo = logUserInfo;
        this.logClientInfo = logClientInfo;
        this.logServerIp = logServerIp;
        this.logApplicationName = logApplicationName;
        this.appName = appName;
    }

    @Override
    public String appendTo(String logName, Logger.EventType eventType, String message) {
        EventTypeLogSupplier eventTypeSupplier = new EventTypeLogSupplier(eventType);
        UserInfoSupplier userInfoSupplier = new UserInfoSupplier();
        userInfoSupplier.setLogUserInfo(this.logUserInfo);
        ClientInfoSupplier clientInfoSupplier = new ClientInfoSupplier();
        clientInfoSupplier.setLogClientInfo(this.logClientInfo);
        ServerInfoSupplier serverInfoSupplier = new ServerInfoSupplier(logName);
        serverInfoSupplier.setLogServerIp(this.logServerIp);
        serverInfoSupplier.setLogApplicationName(this.logApplicationName, this.appName);
        String eventTypeMsg = eventTypeSupplier.get().trim();
        String userInfoMsg = userInfoSupplier.get().trim();
        String clientInfoMsg = clientInfoSupplier.get().trim();
        String serverInfoMsg = serverInfoSupplier.get().trim();
        userInfoMsg = !userInfoMsg.isEmpty() && !clientInfoMsg.isEmpty() ? userInfoMsg + ":" : userInfoMsg;
        serverInfoMsg = !serverInfoMsg.isEmpty() ? "-> " + serverInfoMsg : serverInfoMsg;
        String[] optionalPrefixContent = new String[]{userInfoMsg + clientInfoMsg, serverInfoMsg};
        StringBuilder logPrefix = new StringBuilder();
        logPrefix.append(eventTypeMsg);
        for (String element : optionalPrefixContent) {
            if (element.isEmpty()) continue;
            logPrefix.append(" ");
            logPrefix.append(element);
        }
        return String.format(RESULT_FORMAT, logPrefix.toString(), message);
    }
}

