/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import sqsaml.org.bouncycastle.math.ec.ECFieldElement;
import sqsaml.org.bouncycastle.math.ec.custom.sec.SecP384R1Field;
import sqsaml.org.bouncycastle.math.raw.Nat;
import sqsaml.org.bouncycastle.util.Arrays;
import sqsaml.org.bouncycastle.util.encoders.Hex;

public class SecP384R1FieldElement
extends ECFieldElement.AbstractFp {
    public static final BigInteger Q = new BigInteger(1, Hex.decodeStrict("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFF"));
    protected int[] x;

    public SecP384R1FieldElement(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.signum() < 0 || bigInteger.compareTo(Q) >= 0) {
            throw new IllegalArgumentException("x value invalid for SecP384R1FieldElement");
        }
        this.x = SecP384R1Field.fromBigInteger(bigInteger);
    }

    public SecP384R1FieldElement() {
        this.x = Nat.create(12);
    }

    protected SecP384R1FieldElement(int[] nArray) {
        this.x = nArray;
    }

    @Override
    public boolean isZero() {
        return Nat.isZero(12, this.x);
    }

    @Override
    public boolean isOne() {
        return Nat.isOne(12, this.x);
    }

    @Override
    public boolean testBitZero() {
        return Nat.getBit(this.x, 0) == 1;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat.toBigInteger(12, this.x);
    }

    @Override
    public String getFieldName() {
        return "SecP384R1Field";
    }

    @Override
    public int getFieldSize() {
        return Q.bitLength();
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        int[] nArray = Nat.create(12);
        SecP384R1Field.add(this.x, ((SecP384R1FieldElement)eCFieldElement).x, nArray);
        return new SecP384R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement addOne() {
        int[] nArray = Nat.create(12);
        SecP384R1Field.addOne(this.x, nArray);
        return new SecP384R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        int[] nArray = Nat.create(12);
        SecP384R1Field.subtract(this.x, ((SecP384R1FieldElement)eCFieldElement).x, nArray);
        return new SecP384R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        int[] nArray = Nat.create(12);
        SecP384R1Field.multiply(this.x, ((SecP384R1FieldElement)eCFieldElement).x, nArray);
        return new SecP384R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        int[] nArray = Nat.create(12);
        SecP384R1Field.inv((int[])((SecP384R1FieldElement)eCFieldElement).x, (int[])nArray);
        SecP384R1Field.multiply(nArray, this.x, nArray);
        return new SecP384R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement negate() {
        int[] nArray = Nat.create(12);
        SecP384R1Field.negate(this.x, nArray);
        return new SecP384R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement square() {
        int[] nArray = Nat.create(12);
        SecP384R1Field.square(this.x, nArray);
        return new SecP384R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement invert() {
        int[] nArray = Nat.create(12);
        SecP384R1Field.inv((int[])this.x, (int[])nArray);
        return new SecP384R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement sqrt() {
        int[] nArray = this.x;
        if (Nat.isZero(12, nArray) || Nat.isOne(12, nArray)) {
            return this;
        }
        int[] nArray2 = Nat.create(24);
        int[] nArray3 = Nat.create(12);
        int[] nArray4 = Nat.create(12);
        int[] nArray5 = Nat.create(12);
        int[] nArray6 = Nat.create(12);
        SecP384R1Field.square((int[])nArray, (int[])nArray3, (int[])nArray2);
        SecP384R1Field.multiply((int[])nArray3, (int[])nArray, (int[])nArray3, (int[])nArray2);
        SecP384R1Field.squareN((int[])nArray3, (int)2, (int[])nArray4, (int[])nArray2);
        SecP384R1Field.multiply((int[])nArray4, (int[])nArray3, (int[])nArray4, (int[])nArray2);
        SecP384R1Field.square((int[])nArray4, (int[])nArray4, (int[])nArray2);
        SecP384R1Field.multiply((int[])nArray4, (int[])nArray, (int[])nArray4, (int[])nArray2);
        SecP384R1Field.squareN((int[])nArray4, (int)5, (int[])nArray5, (int[])nArray2);
        SecP384R1Field.multiply((int[])nArray5, (int[])nArray4, (int[])nArray5, (int[])nArray2);
        SecP384R1Field.squareN((int[])nArray5, (int)5, (int[])nArray6, (int[])nArray2);
        SecP384R1Field.multiply((int[])nArray6, (int[])nArray4, (int[])nArray6, (int[])nArray2);
        SecP384R1Field.squareN((int[])nArray6, (int)15, (int[])nArray4, (int[])nArray2);
        SecP384R1Field.multiply((int[])nArray4, (int[])nArray6, (int[])nArray4, (int[])nArray2);
        SecP384R1Field.squareN((int[])nArray4, (int)2, (int[])nArray5, (int[])nArray2);
        SecP384R1Field.multiply((int[])nArray3, (int[])nArray5, (int[])nArray3, (int[])nArray2);
        SecP384R1Field.squareN((int[])nArray5, (int)28, (int[])nArray5, (int[])nArray2);
        SecP384R1Field.multiply((int[])nArray4, (int[])nArray5, (int[])nArray4, (int[])nArray2);
        SecP384R1Field.squareN((int[])nArray4, (int)60, (int[])nArray5, (int[])nArray2);
        SecP384R1Field.multiply((int[])nArray5, (int[])nArray4, (int[])nArray5, (int[])nArray2);
        int[] nArray7 = nArray4;
        SecP384R1Field.squareN((int[])nArray5, (int)120, (int[])nArray7, (int[])nArray2);
        SecP384R1Field.multiply((int[])nArray7, (int[])nArray5, (int[])nArray7, (int[])nArray2);
        SecP384R1Field.squareN((int[])nArray7, (int)15, (int[])nArray7, (int[])nArray2);
        SecP384R1Field.multiply((int[])nArray7, (int[])nArray6, (int[])nArray7, (int[])nArray2);
        SecP384R1Field.squareN((int[])nArray7, (int)33, (int[])nArray7, (int[])nArray2);
        SecP384R1Field.multiply((int[])nArray7, (int[])nArray3, (int[])nArray7, (int[])nArray2);
        SecP384R1Field.squareN((int[])nArray7, (int)64, (int[])nArray7, (int[])nArray2);
        SecP384R1Field.multiply((int[])nArray7, (int[])nArray, (int[])nArray7, (int[])nArray2);
        SecP384R1Field.squareN((int[])nArray7, (int)30, (int[])nArray3, (int[])nArray2);
        SecP384R1Field.square((int[])nArray3, (int[])nArray4, (int[])nArray2);
        return Nat.eq(12, nArray, nArray4) ? new SecP384R1FieldElement(nArray3) : null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecP384R1FieldElement)) {
            return false;
        }
        SecP384R1FieldElement secP384R1FieldElement = (SecP384R1FieldElement)object;
        return Nat.eq(12, this.x, secP384R1FieldElement.x);
    }

    public int hashCode() {
        return Q.hashCode() ^ Arrays.hashCode(this.x, 0, 12);
    }
}

