/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import sqsaml.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import sqsaml.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import sqsaml.org.bouncycastle.crypto.KeyGenerationParameters;
import sqsaml.org.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import sqsaml.org.bouncycastle.crypto.params.DHParameters;
import sqsaml.org.bouncycastle.crypto.params.ElGamalKeyGenerationParameters;
import sqsaml.org.bouncycastle.crypto.params.ElGamalParameters;
import sqsaml.org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import sqsaml.org.bouncycastle.crypto.params.ElGamalPublicKeyParameters;

public class ElGamalKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private ElGamalKeyGenerationParameters param;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (ElGamalKeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper dHKeyGeneratorHelper = DHKeyGeneratorHelper.INSTANCE;
        ElGamalParameters elGamalParameters = this.param.getParameters();
        DHParameters dHParameters = new DHParameters(elGamalParameters.getP(), elGamalParameters.getG(), null, elGamalParameters.getL());
        BigInteger bigInteger = dHKeyGeneratorHelper.calculatePrivate(dHParameters, this.param.getRandom());
        BigInteger bigInteger2 = dHKeyGeneratorHelper.calculatePublic(dHParameters, bigInteger);
        return new AsymmetricCipherKeyPair(new ElGamalPublicKeyParameters(bigInteger2, elGamalParameters), new ElGamalPrivateKeyParameters(bigInteger, elGamalParameters));
    }
}

