/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.bouncycastle.cms;

import sqsaml.org.bouncycastle.asn1.DEROctetString;
import sqsaml.org.bouncycastle.asn1.cms.KEKIdentifier;
import sqsaml.org.bouncycastle.asn1.cms.KEKRecipientInfo;
import sqsaml.org.bouncycastle.asn1.cms.RecipientInfo;
import sqsaml.org.bouncycastle.cms.CMSException;
import sqsaml.org.bouncycastle.cms.RecipientInfoGenerator;
import sqsaml.org.bouncycastle.operator.GenericKey;
import sqsaml.org.bouncycastle.operator.OperatorException;
import sqsaml.org.bouncycastle.operator.SymmetricKeyWrapper;

public abstract class KEKRecipientInfoGenerator
implements RecipientInfoGenerator {
    private final KEKIdentifier kekIdentifier;
    protected final SymmetricKeyWrapper wrapper;

    protected KEKRecipientInfoGenerator(KEKIdentifier kEKIdentifier, SymmetricKeyWrapper symmetricKeyWrapper) {
        this.kekIdentifier = kEKIdentifier;
        this.wrapper = symmetricKeyWrapper;
    }

    public final RecipientInfo generate(GenericKey genericKey) throws CMSException {
        try {
            DEROctetString dEROctetString = new DEROctetString(this.wrapper.generateWrappedKey(genericKey));
            return new RecipientInfo(new KEKRecipientInfo(this.kekIdentifier, this.wrapper.getAlgorithmIdentifier(), dEROctetString));
        }
        catch (OperatorException operatorException) {
            throw new CMSException("exception wrapping content key: " + operatorException.getMessage(), operatorException);
        }
    }
}

