/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.bouncycastle.cert.crmf.jcajce;

import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import sqsaml.org.bouncycastle.asn1.crmf.EncryptedValue;
import sqsaml.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import sqsaml.org.bouncycastle.cert.crmf.CRMFException;
import sqsaml.org.bouncycastle.cert.crmf.EncryptedValueBuilder;
import sqsaml.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import sqsaml.org.bouncycastle.operator.KeyWrapper;
import sqsaml.org.bouncycastle.operator.OutputEncryptor;

public class JcaEncryptedValueBuilder
extends EncryptedValueBuilder {
    public JcaEncryptedValueBuilder(KeyWrapper keyWrapper, OutputEncryptor outputEncryptor) {
        super(keyWrapper, outputEncryptor);
    }

    public EncryptedValue build(X509Certificate x509Certificate) throws CertificateEncodingException, CRMFException {
        return this.build(new JcaX509CertificateHolder(x509Certificate));
    }

    public EncryptedValue build(PrivateKey privateKey) throws CertificateEncodingException, CRMFException {
        return this.build(PrivateKeyInfo.getInstance(privateKey.getEncoded()));
    }
}

