/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.bouncycastle.cert.cmp;

import java.math.BigInteger;
import sqsaml.org.bouncycastle.asn1.cmp.CertStatus;
import sqsaml.org.bouncycastle.asn1.cmp.PKIStatusInfo;
import sqsaml.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import sqsaml.org.bouncycastle.cert.X509CertificateHolder;
import sqsaml.org.bouncycastle.cert.cmp.CMPException;
import sqsaml.org.bouncycastle.cert.cmp.CMPUtil;
import sqsaml.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import sqsaml.org.bouncycastle.operator.DigestCalculator;
import sqsaml.org.bouncycastle.operator.DigestCalculatorProvider;
import sqsaml.org.bouncycastle.operator.OperatorCreationException;
import sqsaml.org.bouncycastle.util.Arrays;

public class CertificateStatus {
    private DigestAlgorithmIdentifierFinder digestAlgFinder;
    private CertStatus certStatus;

    CertificateStatus(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder, CertStatus certStatus) {
        this.digestAlgFinder = digestAlgorithmIdentifierFinder;
        this.certStatus = certStatus;
    }

    public PKIStatusInfo getStatusInfo() {
        return this.certStatus.getStatusInfo();
    }

    public BigInteger getCertRequestID() {
        return this.certStatus.getCertReqId().getValue();
    }

    public boolean isVerified(X509CertificateHolder x509CertificateHolder, DigestCalculatorProvider digestCalculatorProvider) throws CMPException {
        DigestCalculator digestCalculator;
        AlgorithmIdentifier algorithmIdentifier = this.digestAlgFinder.find(x509CertificateHolder.toASN1Structure().getSignatureAlgorithm());
        if (algorithmIdentifier == null) {
            throw new CMPException("cannot find algorithm for digest from signature");
        }
        try {
            digestCalculator = digestCalculatorProvider.get(algorithmIdentifier);
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new CMPException("unable to create digester: " + operatorCreationException.getMessage(), operatorCreationException);
        }
        CMPUtil.derEncodeToStream(x509CertificateHolder.toASN1Structure(), digestCalculator.getOutputStream());
        return Arrays.areEqual(this.certStatus.getCertHash().getOctets(), digestCalculator.getDigest());
    }
}

