/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.bouncycastle.asn1.eac;

import java.math.BigInteger;
import sqsaml.org.bouncycastle.asn1.ASN1Object;
import sqsaml.org.bouncycastle.asn1.ASN1OctetString;
import sqsaml.org.bouncycastle.asn1.ASN1Primitive;
import sqsaml.org.bouncycastle.asn1.ASN1TaggedObject;
import sqsaml.org.bouncycastle.asn1.DEROctetString;
import sqsaml.org.bouncycastle.asn1.DERTaggedObject;

public class UnsignedInteger
extends ASN1Object {
    private int tagNo;
    private BigInteger value;

    public UnsignedInteger(int n, BigInteger bigInteger) {
        this.tagNo = n;
        this.value = bigInteger;
    }

    private UnsignedInteger(ASN1TaggedObject aSN1TaggedObject) {
        this.tagNo = aSN1TaggedObject.getTagNo();
        this.value = new BigInteger(1, ASN1OctetString.getInstance(aSN1TaggedObject, false).getOctets());
    }

    public static UnsignedInteger getInstance(Object object) {
        if (object instanceof UnsignedInteger) {
            return (UnsignedInteger)object;
        }
        if (object != null) {
            return new UnsignedInteger(ASN1TaggedObject.getInstance(object));
        }
        return null;
    }

    private byte[] convertValue() {
        byte[] byArray = this.value.toByteArray();
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            return byArray2;
        }
        return byArray;
    }

    public int getTagNo() {
        return this.tagNo;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(false, this.tagNo, new DEROctetString(this.convertValue()));
    }
}

